/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.Random;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.supplementaries.items.BambooSpikesTippedItem;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class BambooSpikesBlockTile
extends TileEntity {
    public Potion potion = Potions.field_185229_a;
    public int charges = 0;
    public long lastTicked = 0L;
    private final Random rand = new Random();
    public static final float POTION_MULTIPLIER = 0.1f;
    public static final int MAX_CHARGES = 16;

    public BambooSpikesBlockTile() {
        super((TileEntityType)net.mehvahdjukaar.supplementaries.setup.Registry.BAMBOO_SPIKES_TILE.get());
    }

    public int getColor() {
        if (this.hasPotion()) {
            return PotionUtils.func_185183_a((Potion)this.potion);
        }
        return 0xFFFFFF;
    }

    public boolean hasPotion() {
        return this.potion != Potions.field_185229_a && this.charges != 0;
    }

    public boolean isOnCooldown(World world) {
        return world.func_82737_E() - this.lastTicked < 20L;
    }

    public boolean consumeCharge(World world) {
        this.lastTicked = world.func_82737_E();
        --this.charges;
        this.func_70296_d();
        if (this.charges <= 0) {
            this.charges = 0;
            this.potion = Potions.field_185229_a;
            return true;
        }
        return false;
    }

    public void setMissingCharges(int missing) {
        this.charges = Math.max(16 - missing, 0);
    }

    public boolean tryApplyPotion(ItemStack stack) {
        Potion p = PotionUtils.func_185191_c((ItemStack)stack);
        if (this.charges == 0 || this.potion == Potions.field_185229_a || this.potion.equals(p) && this.charges != 16) {
            this.potion = p;
            this.charges = 16;
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            return true;
        }
        return false;
    }

    public boolean interactWithEntity(LivingEntity le, @Nonnull World world) {
        if (this.hasPotion() && !this.isOnCooldown(world)) {
            boolean used = false;
            for (EffectInstance effect : this.potion.func_185170_a()) {
                if (!le.func_70687_e(effect) || le.func_70644_a(effect.func_188419_a())) continue;
                if (effect.func_188419_a().func_76403_b()) {
                    float health = 0.5f;
                    effect.func_188419_a().func_180793_a(null, null, le, effect.func_76458_c(), (double)health);
                } else {
                    le.func_195064_c(new EffectInstance(effect.func_188419_a(), (int)((float)effect.func_76459_b() * 0.1f), effect.func_76458_c()));
                }
                used = true;
            }
            if (used) {
                this.makeParticle();
                return this.consumeCharge(world);
            }
        }
        return false;
    }

    public void makeParticle() {
        int i = this.getColor();
        double d0 = (double)(i >> 16 & 0xFF) / 255.0;
        double d1 = (double)(i >> 8 & 0xFF) / 255.0;
        double d2 = (double)(i & 0xFF) / 255.0;
        BlockPos pos = this.func_174877_v();
        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197625_r, (double)pos.func_177958_n() + 0.5 + ((double)this.rand.nextFloat() - 0.5) * 0.75, (double)pos.func_177956_o() + 0.5 + ((double)this.rand.nextFloat() - 0.5) * 0.75, (double)pos.func_177952_p() + 0.5 + ((double)this.rand.nextFloat() - 0.5) * 0.75, d0, d1, d2);
    }

    public ItemStack getSpikeItem() {
        if (this.hasPotion()) {
            ItemStack stack = BambooSpikesTippedItem.makeSpikeItem(this.potion);
            stack.func_196085_b(stack.func_77958_k() - this.charges);
            return stack;
        }
        return new ItemStack((IItemProvider)net.mehvahdjukaar.supplementaries.setup.Registry.BAMBOO_SPIKES_ITEM.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("Charges", this.charges);
        compound.func_74772_a("LastTicked", this.lastTicked);
        ResourceLocation resourcelocation = Registry.field_212621_j.func_177774_c((Object)this.potion);
        compound.func_74778_a("Potion", resourcelocation.toString());
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.charges = compound.func_74762_e("Charges");
        this.lastTicked = compound.func_74763_f("LastTicked");
        this.potion = PotionUtils.func_185187_c((CompoundNBT)compound);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }
}

