/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.List;
import net.mehvahdjukaar.supplementaries.block.blocks.BellowsBlock;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FireBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BellowsBlockTile
extends TileEntity
implements ITickableTileEntity {
    public float height = 0.0f;
    public float prevHeight = 0.0f;
    private long offset = 0L;
    public boolean isPressed = false;

    public BellowsBlockTile() {
        super((TileEntityType)Registry.BELLOWS_TILE.get());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c);
    }

    public double func_145833_n() {
        return 128.0;
    }

    public VoxelShape getVoxelShape(Direction direction) {
        if (direction.func_176740_k() == Direction.Axis.Y) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)(-this.height), (double)1.0, (double)1.0, (double)(1.0f + this.height));
        }
        return VoxelShapes.func_197873_a((double)0.0, (double)(-this.height), (double)0.0, (double)1.0, (double)(1.0f + this.height), (double)1.0);
    }

    private AxisAlignedBB getHalfBoundingBox(Direction dir) {
        return new AxisAlignedBB(this.field_174879_c).func_191195_a(-0.5 * (double)dir.func_82601_c(), -0.5 * (double)dir.func_96559_d(), -0.5 * (double)dir.func_82599_e());
    }

    private void moveCollidedEntities() {
        Direction dir = this.getDirection().func_176740_k() == Direction.Axis.Y ? Direction.SOUTH : Direction.UP;
        for (int j = 0; j < 2; ++j) {
            AxisAlignedBB axisalignedbb = this.getHalfBoundingBox(dir);
            List list = this.field_145850_b.func_72839_b(null, axisalignedbb);
            if (!list.isEmpty()) {
                block6: for (Entity entity2 : list) {
                    if (entity2.func_184192_z() == PushReaction.IGNORE) continue;
                    AxisAlignedBB entityBB = entity2.func_174813_aQ();
                    double dy = 0.0;
                    double dz = 0.0;
                    float f = this.height + 0.01f;
                    switch (dir) {
                        case SOUTH: {
                            dz = axisalignedbb.field_72334_f + (double)f - entityBB.field_72339_c;
                            if (!(dz < 0.0)) break;
                            continue block6;
                        }
                        case NORTH: {
                            dz = axisalignedbb.field_72339_c - (double)f - entityBB.field_72334_f;
                            if (!(dz > 0.0)) break;
                            continue block6;
                        }
                        default: {
                            dy = axisalignedbb.field_72337_e + (double)f - entityBB.field_72338_b;
                            if (!(dy < 0.0)) break;
                            continue block6;
                        }
                        case DOWN: {
                            dy = axisalignedbb.field_72338_b - (double)f - entityBB.field_72337_e;
                            if (dy > 0.0) continue block6;
                        }
                    }
                    entity2.func_213315_a(MoverType.SHULKER_BOX, new Vector3d(0.0, dy, dz));
                }
            }
            dir = dir.func_176734_d();
        }
    }

    private void pushEntities(Direction facing, float period, float range) {
        double velocity = ServerConfigs.cached.BELLOWS_BASE_VEL_SCALING / (double)period;
        double maxVelocity = ServerConfigs.cached.BELLOWS_MAX_VEL;
        AxisAlignedBB facingBox = CommonUtil.getDirectionBB(this.field_174879_c, facing, (int)range);
        List list = this.field_145850_b.func_217357_a(Entity.class, facingBox);
        block7: for (Entity entity2 : list) {
            double dist;
            if (!this.inLineOfSight(entity2, facing)) continue;
            if (facing == Direction.UP) {
                maxVelocity *= 0.5;
            }
            AxisAlignedBB entityBB = entity2.func_174813_aQ();
            switch (facing) {
                default: {
                    double b = this.field_174879_c.func_177952_p() + 1;
                    if (entityBB.field_72339_c < b) continue block7;
                    dist = entity2.func_226281_cx_() - b;
                    break;
                }
                case NORTH: {
                    double b = this.field_174879_c.func_177952_p();
                    if (entityBB.field_72334_f > b) continue block7;
                    dist = b - entity2.func_226281_cx_();
                    break;
                }
                case EAST: {
                    double b = this.field_174879_c.func_177958_n() + 1;
                    if (entityBB.field_72340_a < b) continue block7;
                    dist = entity2.func_226277_ct_() - b;
                    break;
                }
                case WEST: {
                    double b = this.field_174879_c.func_177958_n();
                    if (entityBB.field_72336_d > b) continue block7;
                    dist = b - entity2.func_226277_ct_();
                    break;
                }
                case UP: {
                    double b = this.field_174879_c.func_177956_o() + 1;
                    if (entityBB.field_72338_b < b) continue block7;
                    dist = entity2.func_226278_cu_() - b;
                    break;
                }
                case DOWN: {
                    double b = this.field_174879_c.func_177956_o();
                    if (entityBB.field_72337_e > b) continue block7;
                    dist = b - entity2.func_226278_cu_();
                }
            }
            velocity *= ((double)range - dist) / (double)range;
            if (!(Math.abs(entity2.func_213322_ci().func_216370_a(facing.func_176740_k())) < maxVelocity)) continue;
            entity2.func_213317_d(entity2.func_213322_ci().func_72441_c((double)facing.func_82601_c() * velocity, (double)facing.func_96559_d() * velocity, (double)facing.func_82599_e() * velocity));
            if (!ServerConfigs.cached.BELLOWS_FLAG) continue;
            entity2.field_70133_I = true;
        }
    }

    private void blowParticles(float air, Direction facing) {
        if (this.field_145850_b.field_73012_v.nextInt(2) == 0 && this.field_145850_b.field_73012_v.nextFloat() < air && !Block.func_220055_a((IWorldReader)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(facing), (Direction)facing.func_176734_d())) {
            this.spawnParticle(this.field_145850_b, this.field_174879_c);
        }
    }

    private void tickFurnaces(BlockPos frontPos) {
        TileEntity te = this.field_145850_b.func_175625_s(frontPos);
        Block b = this.field_145850_b.func_180495_p(frontPos).func_177230_c();
        if (te instanceof ITickableTileEntity && ModTags.isTagged(ModTags.BELLOWS_TICKABLE_TAG, b)) {
            ((ITickableTileEntity)te).func_73660_a();
        }
    }

    private void refreshFire(int n, Direction facing, BlockPos frontPos) {
        for (int i = 0; i < n; ++i) {
            int age;
            BlockState fb = this.field_145850_b.func_180495_p(frontPos);
            if (fb.func_177230_c() instanceof FireBlock && (age = ((Integer)fb.func_177229_b((Property)FireBlock.field_176543_a)).intValue()) != 0) {
                this.field_145850_b.func_180501_a(frontPos, (BlockState)fb.func_206870_a((Property)FireBlock.field_176543_a, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)(age - 7), (int)0, (int)15))), 4);
            }
            frontPos = frontPos.func_177972_a(facing);
        }
    }

    public void func_73660_a() {
        int power = (Integer)this.func_195044_w().func_177229_b((Property)BellowsBlock.POWER);
        this.prevHeight = this.height;
        if (power != 0 && (this.offset != 0L || this.height == 0.0f)) {
            long time = this.field_145850_b.func_82737_E();
            if (this.offset == 0L) {
                this.offset = time;
            }
            float period = (float)ServerConfigs.cached.BELLOWS_PERIOD - (float)(power - 1) * (float)ServerConfigs.cached.BELLOWS_POWER_SCALING;
            Direction facing = this.getDirection();
            float arg = (float)Math.PI * 2 * ((float)(time - this.offset) / period % 1.0f);
            float sin = MathHelper.func_76126_a((float)arg);
            float cos = MathHelper.func_76134_b((float)arg);
            float dh = 0.0625f;
            this.height = 0.0625f * cos - 0.0625f;
            if (this.field_145850_b.field_72995_K) {
                this.blowParticles(sin, facing);
            } else {
                float range = ServerConfigs.cached.BELLOWS_RANGE;
                if (sin > 0.0f) {
                    this.pushEntities(facing, period, range);
                }
                BlockPos frontPos = this.field_174879_c.func_177972_a(facing);
                if (time % (long)(10 - power / 2) == 0L) {
                    this.tickFurnaces(frontPos);
                }
                int n = 0;
                int a = 0;
                while ((float)a <= range) {
                    if (time % (long)(15 * (a + 1)) != 0L) {
                        n = a;
                        break;
                    }
                    ++a;
                }
                this.refreshFire(n, facing, frontPos);
            }
        } else if (this.isPressed) {
            float minH = -0.125f;
            this.height = Math.max(this.height - 0.01f, minH);
            if (this.height > minH) {
                Direction facing = this.getDirection();
                if (this.field_145850_b.field_72995_K) {
                    this.blowParticles(0.8f, facing);
                } else {
                    float range = ServerConfigs.cached.BELLOWS_RANGE;
                    this.pushEntities(facing, ServerConfigs.cached.BELLOWS_PERIOD, range);
                    BlockPos frontPos = this.field_174879_c.func_177972_a(facing);
                    if ((double)this.height % 0.04 == 0.0) {
                        this.tickFurnaces(frontPos);
                    }
                    if ((double)this.height % 0.15 == 0.0) {
                        this.refreshFire((int)range, facing, frontPos);
                    }
                }
            }
        } else {
            this.offset = 0L;
            if (this.height < 0.0f) {
                this.height = Math.min(this.height + 0.01f, 0.0f);
            }
        }
        if (this.prevHeight != 0.0f && this.height != 0.0f) {
            this.moveCollidedEntities();
        }
        this.isPressed = false;
    }

    public boolean inLineOfSight(Entity entity2, Direction facing) {
        int x = facing.func_82601_c() * (MathHelper.func_76128_c((double)entity2.func_226277_ct_()) - this.field_174879_c.func_177958_n());
        int y = facing.func_96559_d() * (MathHelper.func_76128_c((double)entity2.func_226278_cu_()) - this.field_174879_c.func_177956_o());
        int z = facing.func_82599_e() * (MathHelper.func_76128_c((double)entity2.func_226281_cx_()) - this.field_174879_c.func_177952_p());
        boolean flag = true;
        for (int i = 1; i < Math.abs(x + y + z); ++i) {
            if (!Block.func_220055_a((IWorldReader)this.field_145850_b, (BlockPos)this.field_174879_c.func_177967_a(facing, i), (Direction)facing.func_176734_d())) continue;
            flag = false;
        }
        return flag;
    }

    public void spawnParticle(World world, BlockPos pos) {
        Direction dir = this.getDirection();
        double xo = dir.func_82601_c();
        double yo = dir.func_96559_d();
        double zo = dir.func_82599_e();
        double x = xo * 0.5 + (double)pos.func_177958_n() + 0.5 + ((double)world.field_73012_v.nextFloat() - 0.5) / 3.0;
        double y = yo * 0.5 + (double)pos.func_177956_o() + 0.5 + ((double)world.field_73012_v.nextFloat() - 0.5) / 3.0;
        double z = zo * 0.5 + (double)pos.func_177952_p() + 0.5 + ((double)world.field_73012_v.nextFloat() - 0.5) / 3.0;
        double vel = 0.125f + world.field_73012_v.nextFloat() * 0.2f;
        double velX = xo * vel;
        double velY = yo * vel;
        double velZ = zo * vel;
        world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, velX, velY, velZ);
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)BellowsBlock.FACING);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.offset = compound.func_74763_f("Offset");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74772_a("Offset", this.offset);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void onSteppedOn(Entity entityIn) {
        if (this.isPressed) {
            return;
        }
        double b = entityIn.func_174813_aQ().func_72320_b();
        if (b > 0.8 && ((Direction)this.func_195044_w().func_177229_b((Property)BellowsBlock.FACING)).func_176740_k() != Direction.Axis.Y) {
            this.isPressed = true;
        }
    }
}

