/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.blocks.FlagBlock;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.BlockState;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FlagBlockTile
extends TileEntity
implements INameable {
    public final float offset;
    public float counter;
    @Nullable
    private ITextComponent name;
    @Nullable
    private DyeColor baseColor;
    @Nullable
    private ListNBT itemPatterns;
    private boolean receivedData;
    @Nullable
    private List<Pair<BannerPattern, DyeColor>> patterns;

    public FlagBlockTile() {
        super((TileEntityType)Registry.FLAG_TILE.get());
        this.offset = 3.0f * (MathHelper.func_76126_a((float)this.field_174879_c.func_177958_n()) + MathHelper.func_76126_a((float)this.field_174879_c.func_177952_p()));
        this.counter = 0.0f;
        this.baseColor = null;
    }

    public FlagBlockTile(DyeColor color) {
        this();
        this.baseColor = color;
    }

    public static ResourceLocation getFlagLocation(BannerPattern pattern) {
        return new ResourceLocation("supplementaries", "textures/entity/flags/" + pattern.func_190997_a() + ".png");
    }

    public void setCustomName(ITextComponent p_213136_1_) {
        this.name = p_213136_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fromItem(ItemStack stack, DyeColor color) {
        this.itemPatterns = BannerTileEntity.func_230139_a_((ItemStack)stack);
        this.baseColor = color;
        this.patterns = null;
        this.receivedData = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Pair<BannerPattern, DyeColor>> getPatterns() {
        if (this.patterns == null && this.receivedData) {
            this.patterns = BannerTileEntity.func_230138_a_((DyeColor)this.getBaseColor(() -> ((FlagBlockTile)this).func_195044_w()), (ListNBT)this.itemPatterns);
        }
        return this.patterns;
    }

    public ItemStack getItem(BlockState state) {
        ItemStack itemstack = new ItemStack((IItemProvider)FlagBlock.byColor(this.getBaseColor(() -> state)));
        if (this.itemPatterns != null && !this.itemPatterns.isEmpty()) {
            itemstack.func_190925_c("BlockEntityTag").func_218657_a("Patterns", (INBT)this.itemPatterns.func_74737_b());
        }
        if (this.name != null) {
            itemstack.func_200302_a(this.name);
        }
        return itemstack;
    }

    public DyeColor getBaseColor(Supplier<BlockState> state) {
        if (this.baseColor == null) {
            this.baseColor = ((FlagBlock)state.get().func_177230_c()).getColor();
        }
        return this.baseColor;
    }

    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        super.func_189515_b(compoundNBT);
        if (this.itemPatterns != null) {
            compoundNBT.func_218657_a("Patterns", (INBT)this.itemPatterns);
        }
        if (this.name != null) {
            compoundNBT.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.name));
        }
        return compoundNBT;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        if (compoundNBT.func_150297_b("CustomName", 8)) {
            this.name = ITextComponent.Serializer.func_240643_a_((String)compoundNBT.func_74779_i("CustomName"));
        }
        this.baseColor = this.func_145830_o() ? ((FlagBlock)this.func_195044_w().func_177230_c()).getColor() : null;
        this.itemPatterns = compoundNBT.func_150295_c("Patterns", 10);
        this.patterns = null;
        this.receivedData = true;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public double func_145833_n() {
        return 128.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Direction dir = this.getDirection();
        return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75).func_72321_a((double)((float)dir.func_82601_c() * 1.35f), 0.0, (double)((float)dir.func_82599_e() * 1.35f)).func_186670_a(this.field_174879_c);
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)FlagBlock.FACING);
    }

    public ITextComponent func_200200_C_() {
        return this.name != null ? this.name : new TranslationTextComponent("block.supplementaries.flag_" + this.getBaseColor(() -> ((FlagBlockTile)this).func_195044_w()).func_176762_d());
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.name;
    }
}

