/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import net.mehvahdjukaar.supplementaries.block.blocks.GlobeBlock;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GlobeBlockTile
extends TileEntity
implements ITickableTileEntity,
INameable {
    public float yaw = 0.0f;
    public float prevYaw = 0.0f;
    public int face = 0;
    public GlobeType field_200663_e = GlobeType.DEFAULT;
    private ITextComponent customName;

    public GlobeBlockTile() {
        super((TileEntityType)Registry.GLOBE_TILE.get());
    }

    public void setCustomName(ITextComponent name) {
        this.customName = name;
        this.field_200663_e = GlobeType.getGlobeType(name.getString());
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public ITextComponent getDefaultName() {
        return new TranslationTextComponent("block.supplementaries.globe");
    }

    public double func_145833_n() {
        return 80.0;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        this.face = compound.func_74762_e("Face");
        this.yaw = compound.func_74760_g("Yaw");
        this.field_200663_e = GlobeType.values()[compound.func_74762_e("GlobeType")];
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        compound.func_74768_a("Face", this.face);
        compound.func_74776_a("Yaw", this.yaw);
        compound.func_74768_a("GlobeType", this.field_200663_e.ordinal());
        return compound;
    }

    public void spin() {
        int spin = 360;
        int inc = 90;
        this.face -= inc;
        this.face %= 360;
        this.yaw = this.yaw + (float)spin + (float)inc;
        this.prevYaw = this.prevYaw + (float)spin + (float)inc;
        this.func_70296_d();
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.spin();
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void func_73660_a() {
        this.prevYaw = this.yaw;
        if (this.yaw != 0.0f) {
            if (this.yaw < 0.0f) {
                this.yaw = 0.0f;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
            } else {
                this.yaw = this.yaw * 0.94f - 0.7f;
            }
        }
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)GlobeBlock.FACING);
    }

    public static enum GlobeType {
        DEFAULT(null, null, Textures.GLOBE_TEXTURE),
        FLAT(new String[]{"flat", "flat earth"}, new TranslationTextComponent("globe.supplementaries.flat"), Textures.GLOBE_FLAT_TEXTURE),
        MOON(new String[]{"moon", "luna", "selene", "cynthia"}, new TranslationTextComponent("globe.supplementaries.moon"), Textures.GLOBE_MOON_TEXTURE),
        EARTH(new String[]{"earth", "terra", "gaia", "gaea", "tierra", "tellus", "terre"}, new TranslationTextComponent("globe.supplementaries.earth"), Textures.GLOBE_TEXTURE),
        SHEARED(null, null, Textures.GLOBE_SHEARED_TEXTURE),
        CUSTOM_1(new String[]{"plantkillable"}, null, Textures.GLOBE_CUSTOM_1),
        CUSTOM_2(new String[]{"toffanelly"}, null, Textures.GLOBE_CUSTOM_2),
        CUSTOM_3(new String[]{"sylvetichearts"}, null, Textures.GLOBE_CUSTOM_3),
        SUN(new String[]{"sun", "sol", "helios"}, new TranslationTextComponent("globe.supplementaries.sun"), Textures.GLOBE_SUN_TEXTURE),
        CUSTOM_4(new String[]{"agrona"}, null, Textures.GLOBE_CUSTOM_4);

        public final String[] keyWords;
        public final TranslationTextComponent transKeyWord;
        public final ResourceLocation texture;

        private GlobeType(String[] key, TranslationTextComponent tr, ResourceLocation res) {
            this.keyWords = key;
            this.transKeyWord = tr;
            this.texture = res;
        }

        public static GlobeType getGlobeType(String text) {
            String name = text.toLowerCase();
            for (GlobeType n : GlobeType.values()) {
                if (n.keyWords == null) continue;
                if (n.transKeyWord != null && !n.transKeyWord.getString().equals("") && name.equals(n.transKeyWord.getString().toLowerCase())) {
                    return n;
                }
                for (String s : n.keyWords) {
                    if (s.equals("") || !name.equals(s)) continue;
                    return n;
                }
            }
            return DEFAULT;
        }

        public static GlobeType getGlobeType(TileEntity t) {
            if (t instanceof INameable && ((INameable)t).func_145818_k_()) {
                return GlobeType.getGlobeType(((INameable)t).func_200201_e().getString());
            }
            return DEFAULT;
        }
    }
}

