/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.FlagBlockTile;
import net.mehvahdjukaar.supplementaries.block.tiles.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.block.util.IMapDisplay;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.inventories.NoticeBoardContainer;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BannerPatternItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.WritableBookItem;
import net.minecraft.item.WrittenBookItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockDisplayReader;

public class NoticeBoardBlockTile
extends ItemDisplayTile
implements INameable,
IMapDisplay {
    public String text = null;
    private int fontScale = 1;
    private List<IReorderingProcessor> cachedPageLines = Collections.emptyList();
    private boolean inventoryChanged = true;
    public ResourceLocation cachedPattern = null;
    private DyeColor textColor = DyeColor.BLACK;
    public boolean textVisible = true;
    private ITextComponent customName;

    public NoticeBoardBlockTile() {
        super((TileEntityType)Registry.NOTICE_BOARD_TILE.get());
    }

    public void func_213903_a(ITextComponent name) {
        this.customName = name;
    }

    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.supplementaries.notice_board");
    }

    public void updateBoardBlock() {
        boolean b = !this.getDisplayedItem().func_190926_b();
        BlockState _bs = this.field_145850_b.func_180495_p(this.field_174879_c);
        if ((Boolean)_bs.func_177229_b((Property)BlockStateProperties.field_222515_o) != b) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)_bs.func_206870_a((Property)BlockStateProperties.field_222515_o, (Comparable)Boolean.valueOf(b)), 2);
            if (b) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_219617_ah, SoundCategory.BLOCKS, 1.0f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.85f);
            } else {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_219617_ah, SoundCategory.BLOCKS, 1.0f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.5f);
            }
        }
    }

    @Override
    public void func_70296_d() {
        if (this.field_145850_b == null) {
            return;
        }
        this.updateBoardBlock();
        super.func_70296_d();
    }

    @Override
    public ItemStack getMapStack() {
        return this.func_70301_a(0);
    }

    public void updateTileClient() {
        if (this.field_145850_b != null && this.field_145850_b.func_201670_d()) {
            CompoundNBT com;
            ItemStack itemstack = this.getDisplayedItem();
            Item item2 = itemstack.func_77973_b();
            this.cachedPattern = null;
            if (item2 instanceof BannerPatternItem) {
                this.cachedPattern = FlagBlockTile.getFlagLocation(((BannerPatternItem)item2).func_219980_b());
            }
            this.inventoryChanged = true;
            this.cachedPageLines = Collections.emptyList();
            this.text = null;
            if (item2 instanceof WrittenBookItem) {
                CompoundNBT com2 = itemstack.func_77978_p();
                if (WrittenBookItem.func_77828_a((CompoundNBT)com2)) {
                    ListNBT listnbt = com2.func_150295_c("pages", 8).func_74737_b();
                    this.text = listnbt.func_150307_f(0);
                }
            } else if (item2 instanceof WritableBookItem && WritableBookItem.func_150930_a((CompoundNBT)(com = itemstack.func_77978_p()))) {
                ListNBT listnbt = com.func_150295_c("pages", 8).func_74737_b();
                this.text = listnbt.func_150307_f(0);
            }
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        this.textColor = DyeColor.func_204271_a((String)compound.func_74779_i("Color"), (DyeColor)DyeColor.BLACK);
        this.textVisible = compound.func_74767_n("TextVisible");
        this.updateTileClient();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        compound.func_74778_a("Color", this.textColor.func_176762_d());
        compound.func_74757_a("TextVisible", this.textVisible);
        return compound;
    }

    @Override
    public Container func_213906_a(int id, PlayerInventory player) {
        return new NoticeBoardContainer(id, player, (IInventory)this);
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return this.func_191420_l() && (ServerConfigs.cached.NOTICE_BOARDS_UNRESTRICTED || NoticeBoardBlockTile.isPageItem(stack.func_77973_b()));
    }

    public static boolean isPageItem(Item item2) {
        return ItemTags.field_226160_P_ != null && item2.func_206844_a((ITag)ItemTags.field_226160_P_) || item2 instanceof FilledMapItem || item2 instanceof BannerPatternItem;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return this.func_94041_b(index, stack);
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public DyeColor getTextColor() {
        return this.textColor;
    }

    public boolean setTextColor(DyeColor newColor) {
        if (newColor != this.getTextColor()) {
            this.textColor = newColor;
            return true;
        }
        return false;
    }

    public void setFontScale(int s) {
        this.fontScale = s;
    }

    public void setChachedPageLines(List<IReorderingProcessor> l) {
        this.cachedPageLines = l;
    }

    public List<IReorderingProcessor> getCachedPageLines() {
        return this.cachedPageLines;
    }

    public int getFontScale() {
        return this.fontScale;
    }

    public boolean getFlag() {
        if (this.inventoryChanged) {
            this.inventoryChanged = false;
            return true;
        }
        return false;
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)NoticeBoardBlock.FACING);
    }

    public float getYaw() {
        return -this.getDirection().func_185119_l();
    }

    public boolean getAxis() {
        Direction d = this.getDirection();
        return d == Direction.NORTH || d == Direction.SOUTH;
    }

    public int getFrontLight() {
        return WorldRenderer.func_228421_a_((IBlockDisplayReader)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(this.getDirection()));
    }
}

