/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.lang.reflect.Field;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.blocks.SackBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.SafeBlock;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ShulkerBoxContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class SafeBlockTile
extends LockableLootTileEntity
implements ISidedInventory {
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private int numPlayersUsing;
    public String password = null;
    public String ownerName = null;
    public UUID owner = null;
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])Direction.values());

    public SafeBlockTile() {
        super((TileEntityType)Registry.SAFE_TILE.get());
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public void setOwner(UUID owner) {
        this.ownerName = this.field_145850_b.func_217371_b(owner).func_200200_C_().getString();
        this.owner = owner;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
    }

    public void clearOwner() {
        this.ownerName = null;
        this.owner = null;
        this.password = null;
    }

    public boolean isOwnedBy(PlayerEntity player) {
        return this.owner != null && this.owner.equals(player.func_110124_au());
    }

    public boolean isNotOwnedBy(PlayerEntity player) {
        return this.owner != null && !this.owner.equals(player.func_110124_au());
    }

    public ITextComponent func_145748_c_() {
        if (ServerConfigs.cached.SAFE_SIMPLE) {
            if (this.ownerName != null) {
                return new TranslationTextComponent("gui.supplementaries.safe.name", new Object[]{this.ownerName, super.func_145748_c_()});
            }
        } else if (this.password != null) {
            return new TranslationTextComponent("gui.supplementaries.safe.password", new Object[]{this.password, super.func_145748_c_()});
        }
        return super.func_145748_c_();
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.supplementaries.safe");
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            BlockState blockstate = this.func_195044_w();
            boolean flag = (Boolean)blockstate.func_177229_b((Property)SafeBlock.OPEN);
            if (!flag) {
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187617_cK, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.65f);
                this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)blockstate.func_206870_a((Property)SafeBlock.OPEN, (Comparable)Boolean.valueOf(true)), 3);
            }
            this.field_145850_b.func_205220_G_().func_205360_a(this.func_174877_v(), (Object)this.func_195044_w().func_177230_c(), 5);
        }
    }

    public static int calculatePlayersUsing(World world, LockableTileEntity tile, int x, int y, int z) {
        int i = 0;
        for (PlayerEntity playerentity : world.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
            if (!(playerentity.field_71070_bA instanceof ShulkerBoxContainer)) continue;
            try {
                for (Field f : ShulkerBoxContainer.class.getDeclaredFields()) {
                    if (!IInventory.class.isAssignableFrom(f.getType())) continue;
                    f.setAccessible(true);
                    if (f.get(playerentity.field_71070_bA) != tile) continue;
                    ++i;
                }
            }
            catch (Exception exception) {
            }
        }
        return i;
    }

    public void barrelTick() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        this.numPlayersUsing = SafeBlockTile.calculatePlayersUsing(this.field_145850_b, (LockableTileEntity)this, i, j, k);
        if (this.numPlayersUsing > 0) {
            this.field_145850_b.func_205220_G_().func_205360_a(this.func_174877_v(), (Object)this.func_195044_w().func_177230_c(), 5);
        } else {
            BlockState blockstate = this.func_195044_w();
            boolean flag = (Boolean)blockstate.func_177229_b((Property)SackBlock.OPEN);
            if (flag) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187614_cJ, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.65f);
                this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)blockstate.func_206870_a((Property)SackBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.loadFromNbt(nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        return this.saveToNbt(compound);
    }

    public void loadFromNbt(CompoundNBT compound) {
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound) && compound.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.items);
        }
        if (compound.func_74764_b("Owner")) {
            this.owner = compound.func_186857_a("Owner");
        }
        if (compound.func_74764_b("OwnerName")) {
            this.ownerName = compound.func_74779_i("OwnerName");
        }
        if (compound.func_74764_b("Password")) {
            this.password = compound.func_74779_i("Password");
        }
    }

    public CompoundNBT saveToNbt(CompoundNBT compound) {
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191281_a((CompoundNBT)compound, this.items, (boolean)false);
        }
        if (this.owner != null) {
            compound.func_186854_a("Owner", this.owner);
        }
        if (this.ownerName != null) {
            compound.func_74778_a("OwnerName", this.ownerName);
        }
        if (this.password != null) {
            compound.func_74778_a("Password", this.password);
        }
        return compound;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public Container func_213906_a(int id, PlayerInventory player) {
        return new ShulkerBoxContainer(id, player, (IInventory)this);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return CommonUtil.isAllowedInShulker(stack);
    }

    public int[] func_180463_a(Direction side) {
        return IntStream.range(0, this.func_70302_i_()).toArray();
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handlers[facing.ordinal()].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }
}

