/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.stream.IntStream;
import net.mehvahdjukaar.supplementaries.block.blocks.DoormatBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.DoormatBlockTile;
import net.mehvahdjukaar.supplementaries.client.renderers.Const;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.UpdateServerTextHolderPacket;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.fonts.TextInputUtil;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class DoormatGui
extends Screen {
    private TextInputUtil textInputUtil;
    private int editLine = 0;
    private int updateCounter;
    private final DoormatBlockTile tileSign;
    private static final int MAXLINES = 3;
    private final String[] cachedLines;

    public DoormatGui(DoormatBlockTile teSign) {
        super((ITextComponent)new TranslationTextComponent("gui.supplementaries.doormat.edit"));
        this.tileSign = teSign;
        this.cachedLines = (String[])IntStream.range(0, 3).mapToObj(teSign.textHolder::getText).map(ITextComponent::getString).toArray(String[]::new);
    }

    public static void open(DoormatBlockTile sign) {
        Minecraft.func_71410_x().func_147108_a((Screen)new DoormatGui(sign));
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        this.textInputUtil.func_216894_a(codePoint);
        return true;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        this.scrollText((int)delta);
        return true;
    }

    public void scrollText(int amount) {
        this.editLine = Math.floorMod(this.editLine - amount, 3);
        this.textInputUtil.func_238588_f_();
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.scrollText(1);
            return true;
        }
        if (keyCode != 264 && keyCode != 257 && keyCode != 335) {
            return this.textInputUtil.func_216897_a(keyCode) || super.func_231046_a_(keyCode, scanCode, modifiers);
        }
        this.scrollText(-1);
        return true;
    }

    public void func_231023_e_() {
        ++this.updateCounter;
        if (!this.tileSign.func_200662_C().func_223045_a(this.tileSign.func_195044_w().func_177230_c())) {
            this.close();
        }
    }

    public void func_231175_as__() {
        this.close();
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        NetworkHandler.INSTANCE.sendToServer((Object)new UpdateServerTextHolderPacket(this.tileSign.func_174877_v(), this.tileSign.textHolder.signText, this.tileSign.textHolder.lines));
    }

    private void close() {
        this.tileSign.func_70296_d();
        this.field_230706_i_.func_147108_a(null);
    }

    protected void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 4 + 120, 200, 20, DialogTexts.field_240632_c_, p_238847_1_ -> this.close()));
        this.textInputUtil = new TextInputUtil(() -> this.cachedLines[this.editLine], p_238850_1_ -> {
            this.cachedLines[this.editLine] = p_238850_1_;
            this.tileSign.textHolder.setText(this.editLine, (ITextComponent)new StringTextComponent(p_238850_1_));
        }, TextInputUtil.func_238570_a_((Minecraft)this.field_230706_i_), TextInputUtil.func_238582_c_((Minecraft)this.field_230706_i_), p_238848_1_ -> this.field_230706_i_.field_71466_p.func_78256_a(p_238848_1_) <= 75);
    }

    public void func_230430_a_(MatrixStack matrixstack, int mouseX, int mouseY, float partialTicks) {
        RenderHelper.func_227783_c_();
        this.func_230446_a_(matrixstack);
        DoormatGui.func_238472_a_((MatrixStack)matrixstack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)40, (int)0xFFFFFF);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = this.field_230706_i_.func_228019_au_().func_228487_b_();
        matrixstack.func_227860_a_();
        matrixstack.func_227861_a_((double)this.field_230708_k_ / 2.0, 0.0, 50.0);
        matrixstack.func_227862_a_(93.75f, -93.75f, 93.75f);
        matrixstack.func_227861_a_(0.0, -1.25, 0.0);
        matrixstack.func_227860_a_();
        matrixstack.func_227863_a_(Const.Y90);
        matrixstack.func_227861_a_(0.0, -0.5, -0.5);
        matrixstack.func_227863_a_(Const.Z90);
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        BlockState state = (BlockState)this.tileSign.func_195044_w().func_177230_c().func_176223_P().func_206870_a((Property)DoormatBlock.FACING, (Comparable)Direction.EAST);
        blockRenderer.renderBlock(state, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
        matrixstack.func_227865_b_();
        boolean flag1 = this.updateCounter / 6 % 2 == 0;
        matrixstack.func_227861_a_(0.0, 0.0625, 0.0675);
        matrixstack.func_227862_a_(0.010416667f, -0.010416667f, 0.010416667f);
        Matrix4f matrix4f = matrixstack.func_227866_c_().func_227870_a_();
        int i = this.tileSign.textHolder.textColor.func_218388_g();
        int j = this.textInputUtil.func_216896_c();
        int k = this.textInputUtil.func_216898_d();
        int l = this.editLine * 15 - this.tileSign.textHolder.lines * 5;
        for (int i1 = 0; i1 < this.cachedLines.length; ++i1) {
            String s = this.cachedLines[i1];
            if (s == null) continue;
            if (this.field_230712_o_.func_78260_a()) {
                s = this.field_230712_o_.func_147647_b(s);
            }
            float f3 = -this.field_230706_i_.field_71466_p.func_78256_a(s) / 2;
            this.field_230706_i_.field_71466_p.func_238411_a_(s, f3, (float)(i1 * 15 - this.cachedLines.length * 5), i, false, matrix4f, (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0, false);
            if (i1 != this.editLine || j < 0 || !flag1) continue;
            int j1 = this.field_230706_i_.field_71466_p.func_78256_a(s.substring(0, Math.max(Math.min(j, s.length()), 0)));
            int k1 = j1 - this.field_230706_i_.field_71466_p.func_78256_a(s) / 2;
            if (j < s.length()) continue;
            this.field_230706_i_.field_71466_p.func_238411_a_("_", (float)k1, (float)l, i, false, matrix4f, (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0, false);
        }
        irendertypebuffer$impl.func_228461_a_();
        for (int i3 = 0; i3 < this.cachedLines.length; ++i3) {
            String s1 = this.cachedLines[i3];
            if (s1 == null || i3 != this.editLine || j < 0) continue;
            int j3 = this.field_230706_i_.field_71466_p.func_78256_a(s1.substring(0, Math.max(Math.min(j, s1.length()), 0)));
            int k3 = j3 - this.field_230706_i_.field_71466_p.func_78256_a(s1) / 2;
            if (flag1 && j < s1.length()) {
                DoormatGui.func_238467_a_((MatrixStack)matrixstack, (int)k3, (int)(l - 1), (int)(k3 + 1), (int)(l + 9), (int)(0xFF000000 | i));
            }
            if (k == j) continue;
            int l3 = Math.min(j, k);
            int l1 = Math.max(j, k);
            int i2 = this.field_230706_i_.field_71466_p.func_78256_a(s1.substring(0, l3)) - this.field_230706_i_.field_71466_p.func_78256_a(s1) / 2;
            int j2 = this.field_230706_i_.field_71466_p.func_78256_a(s1.substring(0, l1)) - this.field_230706_i_.field_71466_p.func_78256_a(s1) / 2;
            int k2 = Math.min(i2, j2);
            int l2 = Math.max(i2, j2);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.disableTexture();
            RenderSystem.enableColorLogicOp();
            RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_227888_a_(matrix4f, (float)k2, (float)(l + 9), 0.0f).func_225586_a_(0, 0, 255, 255).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f, (float)l2, (float)(l + 9), 0.0f).func_225586_a_(0, 0, 255, 255).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f, (float)l2, (float)l, 0.0f).func_225586_a_(0, 0, 255, 255).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f, (float)k2, (float)l, 0.0f).func_225586_a_(0, 0, 255, 255).func_181675_d();
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            RenderSystem.disableColorLogicOp();
            RenderSystem.enableTexture();
        }
        matrixstack.func_227865_b_();
        RenderHelper.func_227784_d_();
        super.func_230430_a_(matrixstack, mouseX, mouseY, partialTicks);
    }
}

