/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.models;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.client.renderers.BlackboardTextureManager;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class BlackboardBakedModel
implements IDynamicBakedModel {
    private final IModelConfiguration owner;
    private final ModelBakery bakery;
    private final Function<RenderMaterial, TextureAtlasSprite> spriteGetter;
    private final IModelTransform modelTransform;
    private final ItemOverrideList overrides;
    private final ResourceLocation modelLocation;
    private final BlockModel unbaked;
    private final String toRetextureName;

    public BlackboardBakedModel(BlockModel unbaked, IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation, String toRetextureName) {
        this.unbaked = unbaked;
        this.owner = owner;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.modelTransform = modelTransform;
        this.overrides = overrides;
        this.modelLocation = modelLocation;
        this.toRetextureName = toRetextureName;
    }

    private IBakedModel rebake(ResourceLocation replacement) {
        return null;
    }

    public boolean func_177555_b() {
        return this.unbaked.func_178309_b();
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.spriteGetter.apply(this.owner.resolveTexture("particle"));
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public static Set<String> getAllRetextured(IModelConfiguration owner, BlockModel model, String originalSet) {
        HashSet retextured = Sets.newHashSet((Object[])new String[]{originalSet});
        model.field_178318_c.forEach((name, either) -> either.ifRight(parent -> {
            if (retextured.contains(parent)) {
                retextured.add(name);
            }
        }));
        return ImmutableSet.copyOf((Collection)retextured);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, Random random, IModelData data) {
        BlackboardTextureManager.BlackboardKey key;
        if (data != EmptyModelData.INSTANCE && (key = null) != null) {
            ResourceLocation texture = BlackboardTextureManager.INSTANCE.getResoucelocation(key);
            this.unbaked.field_178318_c.replace(this.toRetextureName, Either.right((Object)texture.toString()));
        }
        IBakedModel baked = this.unbaked.func_228813_a_(this.bakery, this.unbaked, this.spriteGetter, this.modelTransform, this.modelLocation, true);
        return baked.getQuads(state, direction, random, data);
    }
}

