/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import java.util.HashMap;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.fluids.SoftFluid;
import net.mehvahdjukaar.supplementaries.fluids.SoftFluidList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidParticleColors {
    public static HashMap<String, Integer> particleColor = new HashMap();

    public static void refresh() {
        particleColor = new HashMap();
        for (Fluid f : ForgeRegistries.FLUIDS) {
            AtlasTexture textureMap;
            TextureAtlasSprite sprite;
            ResourceLocation location;
            String key = f.getRegistryName().toString();
            if (particleColor.containsKey(key) || (location = f.getAttributes().getStillTexture()) == null || (sprite = (textureMap = Minecraft.func_71410_x().func_209506_al().func_229356_a_(AtlasTexture.field_110575_b)).func_195424_a(location)) == null) continue;
            int fluidTint = f.getAttributes().getColor();
            int averageColor = FluidParticleColors.getColorFrom(sprite, fluidTint);
            particleColor.put(key, averageColor);
        }
        for (SoftFluid s : SoftFluidList.ID_MAP.values()) {
            AtlasTexture textureMap;
            TextureAtlasSprite sprite;
            ResourceLocation location;
            if (particleColor.containsKey(s.getID()) || s.isColored() || (location = s.getStillTexture()) == null || (sprite = (textureMap = Minecraft.func_71410_x().func_209506_al().func_229356_a_(AtlasTexture.field_110575_b)).func_195424_a(location)) == null) continue;
            int averageColor = -1;
            try {
                averageColor = FluidParticleColors.getColorFrom(sprite, s.getTintColor());
            }
            catch (Exception e) {
                Supplementaries.LOGGER.warn("failed to load particle color for " + sprite.toString() + " using current resource pack. might be a broken png.mcmeta");
            }
            particleColor.put(s.getID(), averageColor);
        }
    }

    public static int get(Fluid f) {
        return particleColor.getOrDefault(f.getRegistryName().toString(), -1);
    }

    public static int get(String s) {
        return particleColor.getOrDefault(s, -1);
    }

    private static int getColorFrom(TextureAtlasSprite sprite, int tint) {
        if (sprite == null || sprite.func_110970_k() == 0) {
            return -1;
        }
        int tintR = tint >> 16 & 0xFF;
        int tintG = tint >> 8 & 0xFF;
        int tintB = tint & 0xFF;
        int total = 0;
        int totalR = 0;
        int totalB = 0;
        int totalG = 0;
        for (int x = 0; x < sprite.func_94211_a(); ++x) {
            for (int y = 0; y < sprite.func_94216_b(); ++y) {
                int pixel = 0;
                pixel = sprite.getPixelRGBA(0, x, y);
                int pixelB = pixel >> 16 & 0xFF;
                int pixelG = pixel >> 8 & 0xFF;
                int pixelR = pixel & 0xFF;
                ++total;
                totalR += pixelR;
                totalG += pixelG;
                totalB += pixelB;
            }
        }
        if (total <= 0) {
            return -1;
        }
        return ColorHelper.PackedColor.func_233006_a_((int)255, (int)(totalR / total * tintR / 255), (int)(totalG / total * tintG / 255), (int)(totalB / total * tintB / 255));
    }
}

