/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.tiles.BambooSpikesBlockTile;
import net.mehvahdjukaar.supplementaries.client.renderers.HSLColor;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.compat.quark.QuarkPistonPlugin;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;

public class TippedSpikesColor
implements IBlockColor,
IItemColor {
    public static Map<Integer, Integer> cachedColors0 = new HashMap<Integer, Integer>();
    public static Map<Integer, Integer> cachedColors1 = new HashMap<Integer, Integer>();

    public static int getCachedColor(int base, int tint) {
        if (tint == 0) {
            if (!cachedColors0.containsKey(base)) {
                int c = TippedSpikesColor.getProcessedColor(base, tint);
                cachedColors0.put(base, c);
                return c;
            }
            return cachedColors0.get(base);
        }
        if (!cachedColors1.containsKey(base)) {
            int c = TippedSpikesColor.getProcessedColor(base, tint);
            cachedColors1.put(base, c);
            return c;
        }
        return cachedColors1.get(base);
    }

    public int getColor(BlockState state, @Nullable IBlockDisplayReader world, @Nullable BlockPos pos, int tint) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BambooSpikesBlockTile) {
            int color = ((BambooSpikesBlockTile)te).getColor();
            return TippedSpikesColor.getCachedColor(color, tint);
        }
        if (CompatHandler.quark && world instanceof World && (te = QuarkPistonPlugin.getMovingTile(pos, (World)world)) instanceof BambooSpikesBlockTile) {
            int color = ((BambooSpikesBlockTile)te).getColor();
            return TippedSpikesColor.getCachedColor(color, tint);
        }
        return 0xFFFFFF;
    }

    public int getColor(ItemStack stack, int tint) {
        if (tint == 0) {
            return 0xFFFFFF;
        }
        return TippedSpikesColor.getCachedColor(PotionUtils.func_190932_c((ItemStack)stack), tint - 1);
    }

    public static int getProcessedColor(int rgb, int tint) {
        float h;
        float[] hsl = HSLColor.rgbToHsl(rgb);
        if (tint == 1) {
            h = hsl[0];
            boolean b = h > 0.16667f && h < 0.6667f;
            float i = b ? -0.04f : 0.04f;
            hsl[0] = (h + i) % 1.0f;
        }
        hsl = HSLColor.postProcess(hsl);
        h = hsl[0];
        float s = hsl[1];
        float l = hsl[2];
        s = tint == 0 ? s * 0.81f : s * 0.74f;
        return HSLColor.hslToRgb(h, s, l);
    }
}

