/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.mehvahdjukaar.supplementaries.block.tiles.GlobeBlockTile;
import net.mehvahdjukaar.supplementaries.client.renderers.Const;
import net.mehvahdjukaar.supplementaries.client.renderers.GlobeTextureManager;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class GlobeBlockTileRenderer
extends TileEntityRenderer<GlobeBlockTile> {
    public static final ModelRenderer globe = new ModelRenderer(32, 16, 0, 0);
    public static final ModelRenderer flat = new ModelRenderer(32, 32, 0, 0);
    public static final ModelRenderer sheared = new ModelRenderer(32, 32, 0, 0);

    public GlobeBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(GlobeBlockTile tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ModelRenderer selected;
        IVertexBuilder builder;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        matrixStackIn.func_227863_a_(tile.getDirection().func_229384_a_());
        matrixStackIn.func_227863_a_(Const.XN90);
        matrixStackIn.func_227861_a_(0.0, 0.0625, 0.0);
        matrixStackIn.func_227863_a_(Const.XN22);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)(tile.prevYaw + (float)tile.face), (float)(tile.yaw + (float)tile.face))));
        matrixStackIn.func_227863_a_(Const.X180);
        GlobeBlockTile.GlobeType type = ClientConfigs.cached.GLOBE_RANDOM ? tile.field_200663_e : GlobeBlockTile.GlobeType.EARTH;
        switch (type) {
            case FLAT: {
                builder = bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)tile.field_200663_e.texture));
                selected = flat;
                break;
            }
            default: {
                builder = bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)tile.field_200663_e.texture));
                selected = globe;
                break;
            }
            case SHEARED: {
                builder = bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)tile.field_200663_e.texture));
                selected = sheared;
                break;
            }
            case DEFAULT: {
                builder = bufferIn.getBuffer(GlobeTextureManager.INSTANCE.getRenderType(tile.func_145831_w()));
                selected = globe;
            }
        }
        selected.func_228309_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
    }

    static {
        globe.func_228303_a_(-4.0f, -28.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.0f, false);
        globe.func_78793_a(0.0f, 24.0f, 0.0f);
        flat.func_78793_a(0.0f, 24.0f, 0.0f);
        flat.func_78784_a(0, 0).func_228303_a_(-4.0f, -28.0f, -4.0f, 8.0f, 4.0f, 8.0f, 0.0f, false);
        flat.func_78784_a(0, 13).func_228303_a_(-4.0f, -24.0f, -4.0f, 8.0f, 2.0f, 8.0f, 0.0f, false);
        flat.func_78784_a(4, 23).func_228303_a_(-3.0f, -22.0f, -3.0f, 6.0f, 1.0f, 6.0f, 0.0f, false);
        flat.func_78784_a(8, 24).func_228303_a_(-2.0f, -21.0f, -2.0f, 4.0f, 1.0f, 4.0f, 0.0f, false);
        sheared.func_78793_a(0.0f, 24.0f, 0.0f);
        sheared.func_78784_a(0, 0).func_228303_a_(-4.0f, -28.0f, -4.0f, 8.0f, 8.0f, 4.0f, 0.0f, false);
        sheared.func_78784_a(0, 12).func_228303_a_(0.0f, -28.0f, 0.0f, 4.0f, 8.0f, 4.0f, 0.0f, false);
    }
}

