/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.world.data.map.lib.MapDecorationHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.OceanMonumentStructure;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.WoodlandMansionStructure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class AdventurerMapsHandler {
    private static final int SEARCH_RADIUS = 100;
    private static final List<TradeData> customTrades = new ArrayList<TradeData>();

    public static void loadCustomTrades() {
        if (!customTrades.isEmpty()) {
            return;
        }
        try {
            List tradeData = (List)ServerConfigs.tweaks.CUSTOM_ADVENTURER_MAPS_TRADES.get();
            for (List l : tradeData) {
                int s = l.size();
                if (s == 9) {
                    try {
                        ResourceLocation structure = new ResourceLocation((String)l.get(0));
                        ResourceLocation marker = new ResourceLocation((String)l.get(1));
                        String mapName = (String)l.get(2);
                        int color = Integer.parseInt(((String)l.get(3)).replace("0x", ""), 16);
                        int level = Integer.parseInt((String)l.get(4));
                        int minPrice = Integer.parseInt((String)l.get(5));
                        int maxPrice = Integer.parseInt((String)l.get(6));
                        int maxUses = Integer.parseInt((String)l.get(7));
                        int villagerXp = Integer.parseInt((String)l.get(8));
                        customTrades.add(new TradeData(structure, marker, mapName, color, level, minPrice, maxPrice, maxUses, villagerXp));
                    }
                    catch (Exception e) {
                        Supplementaries.LOGGER.warn("failed to parse config 'custom_adventurer_maps' (" + l.toString() + "):" + e);
                    }
                    continue;
                }
                Supplementaries.LOGGER.warn("failed to parse config 'custom_adventurer_maps' (" + l.toString() + "): expected 9 entries, found" + s);
            }
        }
        catch (Exception e) {
            Supplementaries.LOGGER.warn("failed to parse config 'custom_adventurer_maps'.");
        }
    }

    public static void addTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.field_221154_d) {
            Int2ObjectMap trades = event.getTrades();
            for (TradeData data : customTrades) {
                ((List)trades.get(data.level)).add(new AdventureMapTrade(data));
            }
        }
    }

    private static class AdventureMapTrade
    implements VillagerTrades.ITrade {
        public final TradeData tradeData;

        private AdventureMapTrade(TradeData data) {
            this.tradeData = data;
        }

        public MerchantOffer func_221182_a(@Nonnull Entity entity2, @Nonnull Random random) {
            int i = random.nextInt(this.tradeData.maxPrice - this.tradeData.minPrice + 1) + this.tradeData.minPrice;
            ItemStack itemstack = this.createMap(entity2.field_70170_p, entity2.func_233580_cy_());
            if (itemstack.func_190926_b()) {
                return null;
            }
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, i), new ItemStack((IItemProvider)Items.field_151111_aL), itemstack, this.tradeData.maxUses, this.tradeData.villagerXp, 0.2f);
        }

        private ItemStack createMap(World world, BlockPos pos) {
            Structure structure = (Structure)ForgeRegistries.STRUCTURE_FEATURES.getValue(new ResourceLocation("minecraft:igloo"));
            if (!(world instanceof ServerWorld) || structure == null) {
                return ItemStack.field_190927_a;
            }
            BlockPos toPos = ((ServerWorld)world).func_241117_a_(structure, pos, 100, true);
            if (toPos == null) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack = FilledMapItem.func_195952_a((World)world, (int)toPos.func_177958_n(), (int)toPos.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
            FilledMapItem.func_226642_a_((ServerWorld)((ServerWorld)world), (ItemStack)stack);
            if (structure instanceof OceanMonumentStructure) {
                MapData.func_191094_a((ItemStack)stack, (BlockPos)pos, (String)"+", (MapDecoration.Type)MapDecoration.Type.MONUMENT);
            } else if (structure instanceof WoodlandMansionStructure) {
                MapData.func_191094_a((ItemStack)stack, (BlockPos)pos, (String)"+", (MapDecoration.Type)MapDecoration.Type.MANSION);
            } else {
                MapDecorationHandler.addTargetDecoration(stack, toPos, this.tradeData.marker, this.tradeData.mapColor);
            }
            stack.func_200302_a((ITextComponent)new TranslationTextComponent(this.tradeData.mapName));
            return stack;
        }
    }

    private static class TradeData {
        public final ResourceLocation structure;
        public final ResourceLocation marker;
        public final String mapName;
        public final int mapColor;
        public final int level;
        public final int minPrice;
        public final int maxPrice;
        public final int maxUses;
        public final int villagerXp;

        private TradeData(ResourceLocation structure, ResourceLocation marker, String name, int mapColor, int level, int minPrice, int maxPrice, int maxUses, int villagerXp) {
            this.structure = structure;
            this.marker = marker;
            this.mapName = name;
            this.mapColor = mapColor;
            this.level = level;
            this.minPrice = minPrice;
            this.maxPrice = maxPrice;
            this.maxUses = maxUses;
            this.villagerXp = villagerXp;
        }
    }
}

