/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common;

import java.util.Calendar;
import net.mehvahdjukaar.supplementaries.block.blocks.SignPostBlock;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.datagen.types.IWoodType;
import net.mehvahdjukaar.supplementaries.datagen.types.VanillaWoodTypes;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ExperienceBottleItem;
import net.minecraft.item.FishBucketItem;
import net.minecraft.item.HoneyBottleItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MilkBucketItem;
import net.minecraft.item.PotionItem;
import net.minecraft.item.SoupItem;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.Tags;

public class CommonUtil {
    public static Festivity FESTIVITY = Festivity.access$000();
    public static final AxisAlignedBB FENCE_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0).func_197752_a();
    public static final AxisAlignedBB POST_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0).func_197752_a();
    public static final AxisAlignedBB WALL_SHAPE = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)12.0, (double)16.0, (double)12.0).func_197752_a();
    private static final ShulkerBoxTileEntity SHULKER_TILE = new ShulkerBoxTileEntity();

    public static void swapItem(PlayerEntity player, Hand hand, ItemStack oldItem, ItemStack newItem, boolean bothsides) {
        if (!player.field_70170_p.field_72995_K || bothsides) {
            player.func_184611_a(hand, DrinkHelper.func_241445_a_((ItemStack)oldItem.func_77946_l(), (PlayerEntity)player, (ItemStack)newItem, (boolean)player.func_184812_l_()));
        }
    }

    public static void swapItem(PlayerEntity player, Hand hand, ItemStack oldItem, ItemStack newItem) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_184611_a(hand, DrinkHelper.func_241445_a_((ItemStack)oldItem.func_77946_l(), (PlayerEntity)player, (ItemStack)newItem, (boolean)player.func_184812_l_()));
        }
    }

    public static void swapItemNBT(PlayerEntity player, Hand hand, ItemStack oldItem, ItemStack newItem) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_184611_a(hand, DrinkHelper.func_241445_a_((ItemStack)oldItem.func_77946_l(), (PlayerEntity)player, (ItemStack)newItem, (boolean)false));
        }
    }

    public static void swapItem(PlayerEntity player, Hand hand, ItemStack newItem) {
        if (!player.field_70170_p.field_72995_K) {
            player.func_184611_a(hand, DrinkHelper.func_241445_a_((ItemStack)player.func_184586_b(hand).func_77946_l(), (PlayerEntity)player, (ItemStack)newItem, (boolean)player.func_184812_l_()));
        }
    }

    public static boolean isCookie(Item i) {
        return ModTags.isTagged(ModTags.COOKIES, i);
    }

    public static boolean isLantern(Item i) {
        if (i instanceof BlockItem) {
            Block b = ((BlockItem)i).func_179223_d();
            String namespace = b.getRegistryName().func_110624_b();
            if (namespace.equals("skinnedlanterns")) {
                return true;
            }
            return b instanceof LanternBlock && !ServerConfigs.cached.WALL_LANTERN_BLACKLIST.contains(namespace);
        }
        return false;
    }

    public static boolean isBrick(Item i) {
        return ModTags.isTagged(ModTags.BRICKS, i);
    }

    public static boolean isCake(Item i) {
        if (i instanceof BlockItem) {
            Block b = ((BlockItem)i).func_179223_d();
            return b == Blocks.field_150414_aQ || b == Registry.DIRECTIONAL_CAKE.get();
        }
        return false;
    }

    public static boolean isPot(Item i) {
        if (i instanceof BlockItem) {
            Block b = ((BlockItem)i).func_179223_d();
            return b instanceof FlowerPotBlock;
        }
        return false;
    }

    public static JarLiquidType getJarContentTypeFromItem(ItemStack stack) {
        Item i = stack.func_77973_b();
        if (i instanceof PotionItem) {
            if (PotionUtils.func_185191_c((ItemStack)stack).equals(Potions.field_185230_b)) {
                return JarLiquidType.WATER;
            }
            return JarLiquidType.POTION;
        }
        if (i instanceof FishBucketItem) {
            if (i == Items.field_203797_aN) {
                return JarLiquidType.COD;
            }
            if (i == Items.field_203795_aL) {
                return JarLiquidType.PUFFER_FISH;
            }
            if (i == Items.field_203796_aM) {
                return JarLiquidType.SALMON;
            }
            return JarLiquidType.TROPICAL_FISH;
        }
        if (i == Items.field_151129_at) {
            return JarLiquidType.LAVA;
        }
        if (i instanceof HoneyBottleItem) {
            return JarLiquidType.HONEY;
        }
        if (i instanceof MilkBucketItem) {
            return JarLiquidType.MILK;
        }
        if (i == Items.field_185157_bK) {
            return JarLiquidType.DRAGON_BREATH;
        }
        if (i instanceof ExperienceBottleItem) {
            return JarLiquidType.XP;
        }
        if (i == Items.field_151009_A) {
            return JarLiquidType.MUSHROOM_STEW;
        }
        if (i == Items.field_179560_bq) {
            return JarLiquidType.RABBIT_STEW;
        }
        if (i == Items.field_185165_cW) {
            return JarLiquidType.BEETROOT_SOUP;
        }
        if (i instanceof SuspiciousStewItem) {
            return JarLiquidType.SUSPICIOUS_STEW;
        }
        if (i == Items.field_151131_as) {
            return JarLiquidType.WATER;
        }
        if (CommonUtil.isCookie(i)) {
            return JarLiquidType.COOKIES;
        }
        return JarLiquidType.EMPTY;
    }

    public static int getLiquidCountFromItem(Item i) {
        if (i instanceof FishBucketItem) {
            return 1;
        }
        if (i instanceof MilkBucketItem || i == Items.field_151129_at || i == Items.field_151131_as) {
            return 3;
        }
        if (i instanceof SoupItem || i instanceof SuspiciousStewItem) {
            return 2;
        }
        return 1;
    }

    public static AxisAlignedBB getDirectionBB(BlockPos pos, Direction facing, int offset) {
        BlockPos endPos = pos.func_177967_a(facing, offset);
        switch (facing) {
            default: {
                endPos = endPos.func_177982_a(1, 1, 0);
                break;
            }
            case SOUTH: {
                endPos = endPos.func_177982_a(1, 1, 1);
                pos = pos.func_177982_a(0, 0, 1);
                break;
            }
            case UP: {
                endPos = endPos.func_177982_a(1, 1, 1);
                pos = pos.func_177982_a(0, 1, 0);
                break;
            }
            case EAST: {
                endPos = endPos.func_177982_a(1, 1, 1);
                pos = pos.func_177982_a(1, 0, 0);
                break;
            }
            case WEST: {
                endPos = endPos.func_177982_a(0, 1, 1);
                break;
            }
            case DOWN: {
                endPos = endPos.func_177982_a(1, 0, 1);
            }
        }
        return new AxisAlignedBB(pos, endPos);
    }

    public static boolean isShapeEqual(AxisAlignedBB s1, AxisAlignedBB s2) {
        return s1.field_72340_a == s2.field_72340_a && s1.field_72338_b == s2.field_72338_b && s1.field_72339_c == s2.field_72339_c && s1.field_72336_d == s2.field_72336_d && s1.field_72337_e == s2.field_72337_e && s1.field_72334_f == s2.field_72334_f;
    }

    public static int getPostSize(BlockState state, BlockPos pos, IWorldReader world) {
        Block block2 = state.func_177230_c();
        VoxelShape shape = state.func_196954_c((IBlockReader)world, pos);
        if (shape != VoxelShapes.func_197880_a()) {
            AxisAlignedBB s = shape.func_197752_a();
            if (block2 instanceof FenceBlock || block2 instanceof SignPostBlock || block2.func_203417_a((ITag)Tags.Blocks.FENCES) || CommonUtil.isShapeEqual(FENCE_SHAPE, s)) {
                return 1;
            }
            if (block2 instanceof WallBlock || block2.func_203417_a((ITag)BlockTags.field_219757_z) || CommonUtil.isShapeEqual(WALL_SHAPE, s)) {
                return 2;
            }
            if (CommonUtil.isShapeEqual(POST_SHAPE, s)) {
                return 1;
            }
        }
        return 0;
    }

    public static boolean isVertical(BlockState state) {
        if (state.func_235901_b_((Property)BlockStateProperties.field_208148_A)) {
            return state.func_177229_b((Property)BlockStateProperties.field_208148_A) == Direction.Axis.Y;
        }
        return true;
    }

    public static boolean isNotExtended(BlockState state) {
        if (state.func_235901_b_((Property)BlockStateProperties.field_208181_h)) {
            return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208181_h) == false;
        }
        return true;
    }

    public static boolean isPost(BlockState state) {
        return CommonUtil.isVertical(state) && CommonUtil.isNotExtended(state) && ModTags.isTagged(ModTags.POSTS, state.func_177230_c());
    }

    public static boolean isAllowedInShulker(ItemStack stack) {
        return SHULKER_TILE.func_180462_a(0, stack, null);
    }

    public static boolean withinDistanceDown(BlockPos pos, Vector3d vector, double distW, double distDown) {
        double dx = vector.func_82615_a() - ((double)pos.func_177958_n() + 0.5);
        double dy = vector.func_82617_b() - ((double)pos.func_177956_o() + 0.5);
        double dz = vector.func_82616_c() - ((double)pos.func_177952_p() + 0.5);
        double mydistW = dx * dx + dz * dz;
        return mydistW < distW * distW && dy < distW && dy > -distDown;
    }

    public static boolean canPlace(BlockItemUseContext context, BlockState state) {
        PlayerEntity playerentity = context.func_195999_j();
        ISelectionContext iselectioncontext = playerentity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)playerentity);
        return state.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a()) && context.func_195991_k().func_226663_a_(state, context.func_195995_a(), iselectioncontext);
    }

    public static enum TempWoodType implements IStringSerializable
    {
        NONE("none"),
        OAK("oak"),
        BIRCH("birch"),
        SPRUCE("spruce"),
        JUNGLE("jungle"),
        ACACIA("acacia"),
        DARK_OAK("dark_oak"),
        CRIMSON("crimson"),
        WARPED("warped");

        private final String name;

        private TempWoodType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public IWoodType convertWoodType() {
            switch (this) {
                default: {
                    return VanillaWoodTypes.OAK;
                }
                case BIRCH: {
                    return VanillaWoodTypes.BIRCH;
                }
                case SPRUCE: {
                    return VanillaWoodTypes.SPRUCE;
                }
                case JUNGLE: {
                    return VanillaWoodTypes.JUNGLE;
                }
                case DARK_OAK: {
                    return VanillaWoodTypes.DARK_OAK;
                }
                case WARPED: {
                    return VanillaWoodTypes.WARPED;
                }
                case CRIMSON: {
                    return VanillaWoodTypes.CRIMSON;
                }
                case ACACIA: 
            }
            return VanillaWoodTypes.ACACIA;
        }
    }

    public static enum JarLiquidType {
        WATER(Textures.WATER_TEXTURE, 4159204, true, 1.0f, true, true, false, -1),
        LAVA(Textures.LAVA_TEXTURE, 16608533, false, 1.0f, false, true, false, -1),
        MILK(Textures.MILK_TEXTURE, 0xFFFFFF, false, 1.0f, false, true, false, -1),
        POTION(Textures.POTION_TEXTURE_FLOW, 4159204, true, 0.88f, true, false, false, -1),
        HONEY(Textures.HONEY_TEXTURE, 16754448, false, 0.85f, true, false, false, -1),
        DRAGON_BREATH(Textures.DRAGON_BREATH_TEXTURE, 0xFF33FF, true, 0.8f, true, false, false, -1),
        XP(Textures.XP_TEXTURE, 9371409, false, 0.95f, true, false, false, -1),
        TROPICAL_FISH(Textures.WATER_TEXTURE, 4159204, true, 1.0f, false, true, false, 0),
        SALMON(Textures.WATER_TEXTURE, 4159204, true, 1.0f, false, true, false, 1),
        COD(Textures.WATER_TEXTURE, 4159204, true, 1.0f, false, true, false, 2),
        PUFFER_FISH(Textures.WATER_TEXTURE, 4159204, true, 1.0f, false, true, false, 3),
        COOKIES(Textures.WATER_TEXTURE, 0, false, 1.0f, false, false, false, -1),
        EMPTY(Textures.WATER_TEXTURE, 0, false, 1.0f, false, false, false, -1),
        MUSHROOM_STEW(Textures.SOUP_TEXTURE, 16756105, true, 1.0f, false, false, true, -1),
        BEETROOT_SOUP(Textures.SOUP_TEXTURE, 13186100, true, 1.0f, false, false, true, -1),
        SUSPICIOUS_STEW(Textures.SOUP_TEXTURE, 12249183, true, 1.0f, false, false, true, -1),
        RABBIT_STEW(Textures.SOUP_TEXTURE, 16748623, true, 1.0f, false, false, true, -1);

        public final ResourceLocation texture;
        public final float opacity;
        public final int color;
        public final boolean applyColor;
        public final boolean bucket;
        public final boolean bottle;
        public final int fishType;
        public final boolean bowl;

        private JarLiquidType(ResourceLocation texture, int color, boolean applycolor, float opacity, boolean bottle, boolean bucket, boolean bowl, int fishtype) {
            this.texture = texture;
            this.color = color;
            this.applyColor = applycolor;
            this.opacity = opacity;
            this.bottle = bottle;
            this.bucket = bucket;
            this.bowl = bowl;
            this.fishType = fishtype;
        }

        public boolean isEmpty() {
            return this == EMPTY;
        }

        public boolean isFish() {
            return this.fishType != -1;
        }

        public boolean isLava() {
            return this == LAVA;
        }

        public boolean isWater() {
            return this.isFish() || this == WATER;
        }

        public int getLightLevel() {
            return this.isLava() ? 15 : 0;
        }

        public Item getReturnItem() {
            if (this.bottle) {
                return Items.field_151069_bo;
            }
            if (this.bucket) {
                return Items.field_151133_ar;
            }
            if (this.bowl) {
                return Items.field_151054_z;
            }
            return null;
        }

        public boolean makesSound() {
            return this.bottle || this.bowl || this.bucket;
        }

        public SoundEvent getSound() {
            if (this.isLava()) {
                return SoundEvents.field_187633_N;
            }
            if (this.isFish()) {
                return SoundEvents.field_203814_aa;
            }
            return SoundEvents.field_187630_M;
        }

        public SoundEvent getEatSound() {
            return this == COOKIES ? SoundEvents.field_187537_bA : SoundEvents.field_187664_bz;
        }
    }

    public static enum Festivity {
        NONE,
        HALLOWEEN,
        APRILS_FOOL,
        CHRISTMAS,
        EARTH_DAY,
        ST_VALENTINE;


        public boolean isHalloween() {
            return this == HALLOWEEN;
        }

        public boolean isAprilsFool() {
            return this == APRILS_FOOL;
        }

        public boolean isStValentine() {
            return this == ST_VALENTINE;
        }

        public boolean isChristmas() {
            return this == CHRISTMAS;
        }

        public boolean isEarthDay() {
            return this == EARTH_DAY;
        }

        private static Festivity get() {
            Calendar calendar = Calendar.getInstance();
            if (calendar.get(2) == 9 && calendar.get(5) >= 29 || calendar.get(2) == 10 && calendar.get(5) <= 1) {
                return HALLOWEEN;
            }
            if (calendar.get(2) == 3 && calendar.get(5) == 1) {
                return APRILS_FOOL;
            }
            if (calendar.get(2) == 1 && calendar.get(5) == 14) {
                return ST_VALENTINE;
            }
            if (calendar.get(2) == 3 && calendar.get(5) == 22) {
                return EARTH_DAY;
            }
            if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
                return CHRISTMAS;
            }
            return NONE;
        }

        static /* synthetic */ Festivity access$000() {
            return Festivity.get();
        }
    }
}

