/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class FlowerPotHelper {
    private static Map<Block, Map<ResourceLocation, Supplier<? extends Block>>> FULL_POTS;
    private static final List<BlockState> FULL_POT_LIST;

    public static BlockState getAprilPot() {
        int ind = (int)(System.currentTimeMillis() / 15000L % (long)FULL_POT_LIST.size());
        return FULL_POT_LIST.get(ind);
    }

    public static Block getFullPot(FlowerPotBlock emptyPot, Block flowerBlock) {
        return FULL_POTS.get(emptyPot.getEmptyPot()).getOrDefault(flowerBlock.getRegistryName(), (Supplier<? extends Block>)Blocks.field_150350_a.delegate).get();
    }

    public static boolean isEmptyPot(Block b) {
        return FULL_POTS != null && b != null && FULL_POTS.containsKey(b);
    }

    public static void init() {
        HashSet<FlowerPotBlock> emptyPots = new HashSet<FlowerPotBlock>();
        for (Block b : ForgeRegistries.BLOCKS) {
            if (!(b instanceof FlowerPotBlock)) continue;
            emptyPots.add(((FlowerPotBlock)b).getEmptyPot());
        }
        FULL_POTS = Maps.newHashMap();
        for (FlowerPotBlock pot2 : emptyPots) {
            try {
                Field f = ObfuscationReflectionHelper.findField(FlowerPotBlock.class, (String)"fullPots");
                f.setAccessible(true);
                FULL_POTS.put((Block)pot2, (Map)f.get(pot2));
                FULL_POT_LIST.addAll(((Map)f.get(pot2)).values().stream().map(s -> ((Block)s.get()).func_176223_P()).collect(Collectors.toList()));
            }
            catch (Exception ignored) {
                Supplementaries.LOGGER.info("Failed to create flower pots");
            }
        }
        emptyPots.removeIf(pot -> !FULL_POTS.containsKey(pot));
    }

    static {
        FULL_POT_LIST = new ArrayList<BlockState>();
    }
}

