/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.configs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.SyncConfigsPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ConfigHandler {
    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(ConfigHandler::onPlayerLoggedIn);
        MinecraftForge.EVENT_BUS.addListener(ConfigHandler::onPlayerLoggedOut);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ConfigHandler::reloadConfigsEvent);
    }

    public static void reloadConfigsEvent(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getSpec() == ServerConfigs.SERVER_CONFIG) {
            ConfigHandler.syncServerConfigs();
            ServerConfigs.cached.refresh();
        } else if (event.getConfig().getSpec() == ClientConfigs.CLIENT_CONFIG) {
            ClientConfigs.cached.refresh();
        }
    }

    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            ConfigHandler.syncServerConfigs(event.getPlayer());
        }
    }

    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            // empty if block
        }
        ServerConfigs.loadLocal();
        ServerConfigs.cached.refresh();
    }

    public static Path getServerConfigPath() {
        return FMLPaths.CONFIGDIR.get().resolve("supplementaries-common.toml").toAbsolutePath();
    }

    public static void syncServerConfigs() {
        PlayerList playerList;
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer != null && (playerList = currentServer.func_184103_al()) != null) {
            for (ServerPlayerEntity player : playerList.func_181057_v()) {
                ConfigHandler.syncServerConfigs((PlayerEntity)player);
            }
        }
    }

    public static void syncServerConfigs(PlayerEntity player) {
        try {
            byte[] configData = Files.readAllBytes(ConfigHandler.getServerConfigPath());
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SyncConfigsPacket(configData));
        }
        catch (IOException e) {
            Supplementaries.LOGGER.error("supplementaries: Failed to sync common configs", (Throwable)e);
        }
    }
}

