/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.configs;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.lang.reflect.Field;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryConfigs {
    public static ForgeConfigSpec REGISTRY_CONFIG;

    public static void load() {
        CommentedFileConfig replacementConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("supplementaries-registry.toml")).sync().preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();
        replacementConfig.load();
        replacementConfig.save();
        REGISTRY_CONFIG.setConfig((CommentedConfig)replacementConfig);
        reg.HAS_MINESHAFT_LANTERN = (Boolean)reg.COPPER_LANTERN_ENABLED.get();
        reg.HAS_STRONGHOLD_SCONCE = (Boolean)reg.SCONCE_ENABLED.get();
    }

    static {
        ForgeConfigSpec.Builder REGISTRY_BUILDER = new ForgeConfigSpec.Builder();
        reg.init(REGISTRY_BUILDER);
        REGISTRY_CONFIG = REGISTRY_BUILDER.build();
        try {
            ModList ml = ModList.get();
            if (ml.isLoaded("mysticalworld") || ml.isLoaded("immersiveengineering") || ml.isLoaded("bluepower") || ml.isLoaded("silents_mechanisms ") || ml.isLoaded("thermal") || ml.isLoaded("iceandfire") || ml.isLoaded("silentgems") || ml.isLoaded("occultism")) {
                reg.HAS_SILVER = true;
            }
            if (ml.isLoaded("create")) {
                reg.HAS_BRASS = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class reg {
        public static ForgeConfigSpec.BooleanValue FIREFLY_ENABLED;
        public static ForgeConfigSpec.BooleanValue PLANTER_ENABLED;
        public static ForgeConfigSpec.BooleanValue CLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue PEDESTAL_ENABLED;
        public static ForgeConfigSpec.BooleanValue WIND_VANE_ENABLED;
        public static ForgeConfigSpec.BooleanValue ILLUMINATOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue NOTICE_BOARD_ENABLED;
        public static ForgeConfigSpec.BooleanValue CRANK_ENABLED;
        public static ForgeConfigSpec.BooleanValue JAR_ENABLED;
        public static ForgeConfigSpec.BooleanValue FAUCET_ENABLED;
        public static ForgeConfigSpec.BooleanValue TURN_TABLE_ENABLED;
        public static ForgeConfigSpec.BooleanValue PISTON_LAUNCHER_ENABLED;
        public static ForgeConfigSpec.BooleanValue SPEAKER_BLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue SIGN_POST_ENABLED;
        public static ForgeConfigSpec.BooleanValue HANGING_SIGN_ENABLED;
        public static ForgeConfigSpec.BooleanValue BELLOWS_ENABLED;
        public static ForgeConfigSpec.BooleanValue SCONCE_ENABLED;
        public static ForgeConfigSpec.BooleanValue SCONCE_ENDER_ENABLED;
        public static ForgeConfigSpec.BooleanValue SCONCE_GREEN_ENABLED;
        public static ForgeConfigSpec.BooleanValue SCONCE_SOUL_ENABLED;
        public static ForgeConfigSpec.BooleanValue CANDELABRA_ENABLED;
        public static ForgeConfigSpec.BooleanValue CAGE_ENABLED;
        public static ForgeConfigSpec.BooleanValue ITEM_SHELF_ENABLED;
        public static ForgeConfigSpec.BooleanValue SCONCE_LEVER_ENABLED;
        public static ForgeConfigSpec.BooleanValue CANDLE_HOLDER_ENABLED;
        public static ForgeConfigSpec.BooleanValue COG_BLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue STONE_LAMP_ENABLED;
        public static ForgeConfigSpec.BooleanValue GLOBE_ENABLED;
        public static ForgeConfigSpec.BooleanValue HOURGLASS_ENABLED;
        public static ForgeConfigSpec.BooleanValue LASER_ENABLED;
        public static ForgeConfigSpec.BooleanValue FLAG_ENABLED;
        public static ForgeConfigSpec.BooleanValue SACK_ENABLED;
        public static ForgeConfigSpec.BooleanValue BLACKBOARD_ENABLED;
        public static ForgeConfigSpec.BooleanValue SAFE_ENABLED;
        public static ForgeConfigSpec.BooleanValue COPPER_LANTERN_ENABLED;
        public static ForgeConfigSpec.BooleanValue FLUTE_ENABLED;
        public static ForgeConfigSpec.BooleanValue GOLD_TRAPDOOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue GOLD_DOOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue BAMBOO_SPIKES_ENABLED;
        public static ForgeConfigSpec.BooleanValue CHECKERBOARD_ENABLED;
        public static ForgeConfigSpec.BooleanValue NETHERITE_TRAPDOOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue NETHERITE_DOOR_ENABLED;
        public static ForgeConfigSpec.BooleanValue PANCAKES_ENABLED;
        public static ForgeConfigSpec.BooleanValue LOCK_BLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue FLAX_ENABLED;
        public static ForgeConfigSpec.BooleanValue ROPE_ENABLED;
        public static ForgeConfigSpec.BooleanValue ROPE_ARROW_ENABLED;
        public static ForgeConfigSpec.BooleanValue PULLEY_ENABLED;
        public static ForgeConfigSpec.BooleanValue FODDER_ENABLED;
        public static ForgeConfigSpec.BooleanValue BOMB_ENABLED;
        public static ForgeConfigSpec.BooleanValue MAGMA_CREAM_BLOCK_ENABLED;
        public static ForgeConfigSpec.BooleanValue CRIMSON_LANTERN_ENABLED;
        public static ForgeConfigSpec.BooleanValue STICK_ENABLED;
        public static ForgeConfigSpec.BooleanValue ROD_ENABLED;
        public static ForgeConfigSpec.BooleanValue DAUB_ENABLED;
        public static ForgeConfigSpec.BooleanValue TIMBER_FRAME_ENABLED;
        public static ForgeConfigSpec.BooleanValue TILE_ENABLED;
        public static ForgeConfigSpec.BooleanValue GOBLET_ENABLED;
        public static ForgeConfigSpec.BooleanValue RAKED_GRAVEL_ENABLED;
        public static ForgeConfigSpec.BooleanValue JAR_TAB;
        public static ForgeConfigSpec.BooleanValue CREATIVE_TAB;
        public static ForgeConfigSpec.BooleanValue DISPENSERS;
        public static ForgeConfigSpec.BooleanValue FLAG_FORCE_ENABLED;
        public static boolean HAS_SILVER;
        public static boolean HAS_BRASS;
        public static boolean HAS_MINESHAFT_LANTERN;
        public static boolean HAS_STRONGHOLD_SCONCE;

        public static boolean isEnabled(String path) {
            if (path.equals("bomb_blue")) {
                return false;
            }
            if (path.equals("flag")) {
                return (Boolean)FLAG_FORCE_ENABLED.get();
            }
            if (path.equals("firefly_jar")) {
                return (Boolean)FIREFLY_ENABLED.get() != false && (Boolean)JAR_ENABLED.get() != false;
            }
            if (path.equals("brass_lantern")) {
                return HAS_BRASS;
            }
            if (path.equals("candelabra_silver")) {
                return (Boolean)CANDELABRA_ENABLED.get() != false && HAS_SILVER;
            }
            if (path.equals("soul_jar")) {
                return (Boolean)JAR_ENABLED.get();
            }
            if (path.equals("key")) {
                return (Boolean)NETHERITE_DOOR_ENABLED.get() != false || (Boolean)NETHERITE_TRAPDOOR_ENABLED.get() != false || (Boolean)SAFE_ENABLED.get() != false;
            }
            for (Field f : reg.class.getDeclaredFields()) {
                try {
                    ForgeConfigSpec.BooleanValue b;
                    String p;
                    if (!ForgeConfigSpec.BooleanValue.class.isAssignableFrom(f.getType()) || !(p = (String)(b = (ForgeConfigSpec.BooleanValue)f.get(null)).getPath().get(b.getPath().size() - 1)).equals(path)) continue;
                    return (Boolean)b.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }

        private static void init(ForgeConfigSpec.Builder builder) {
            builder.comment("all these don't actually disable blocks anymore, they just remove their recipe and remove them from the creative tabs(like all other mods do)\nto access server configuration go into /saves/serverconfigs").push("general");
            CREATIVE_TAB = builder.comment("enable creative tab").define("creative_tab", false);
            DISPENSERS = builder.comment("set to false to disable custom dispenser behaviors (filling jars) if for some reason they are causing trouble").define("dispensers", true);
            JAR_TAB = builder.comment("creates a creative tab full of filled jars").define("jar_tab", false);
            builder.pop();
            builder.comment("Enable and disable blocks / entities");
            builder.push("registration");
            builder.push("blocks");
            PLANTER_ENABLED = builder.define("planter", true);
            CLOCK_ENABLED = builder.define("clock_block", true);
            PEDESTAL_ENABLED = builder.define("pedestal", true);
            WIND_VANE_ENABLED = builder.define("wind_vane", true);
            ILLUMINATOR_ENABLED = builder.define("redstone_illuminator", true);
            NOTICE_BOARD_ENABLED = builder.define("notice_board", true);
            CRANK_ENABLED = builder.define("crank", true);
            JAR_ENABLED = builder.define("jar", true);
            FAUCET_ENABLED = builder.define("faucet", true);
            TURN_TABLE_ENABLED = builder.define("turn_table", true);
            PISTON_LAUNCHER_ENABLED = builder.define("piston_launcher", true);
            SPEAKER_BLOCK_ENABLED = builder.define("speaker_block", true);
            SIGN_POST_ENABLED = builder.define("sign_post", true);
            HANGING_SIGN_ENABLED = builder.define("hanging_sign", true);
            BELLOWS_ENABLED = builder.define("bellows", true);
            SCONCE_ENABLED = builder.define("sconce", true);
            SCONCE_GREEN_ENABLED = builder.define("sconce_green", false);
            SCONCE_ENDER_ENABLED = builder.define("sconce_ender", true);
            SCONCE_SOUL_ENABLED = builder.define("sconce_soul", true);
            CANDELABRA_ENABLED = builder.define("candelabra", true);
            CAGE_ENABLED = builder.define("cage", true);
            ITEM_SHELF_ENABLED = builder.define("item_shelf", true);
            SCONCE_LEVER_ENABLED = builder.define("sconce_lever", true);
            COG_BLOCK_ENABLED = builder.define("cog_block", true);
            CANDLE_HOLDER_ENABLED = builder.define("candle_holder", true);
            GLOBE_ENABLED = builder.define("globe", true);
            HOURGLASS_ENABLED = builder.define("hourglass", true);
            SACK_ENABLED = builder.define("sack", true);
            BLACKBOARD_ENABLED = builder.define("blackboard", true);
            SAFE_ENABLED = builder.define("safe", true);
            COPPER_LANTERN_ENABLED = builder.define("copper_lantern", true);
            FLUTE_ENABLED = builder.define("flute", true);
            GOLD_TRAPDOOR_ENABLED = builder.define("gold_trapdoor", true);
            GOLD_DOOR_ENABLED = builder.define("gold_door", true);
            BAMBOO_SPIKES_ENABLED = builder.define("bamboo_spikes", true);
            STONE_LAMP_ENABLED = builder.define("stone_lamp", true);
            CHECKERBOARD_ENABLED = builder.define("checker_block", true);
            NETHERITE_DOOR_ENABLED = builder.define("netherite_door", true);
            NETHERITE_TRAPDOOR_ENABLED = builder.define("netherite_trapdoor", true);
            PANCAKES_ENABLED = builder.define("pancake", true);
            LOCK_BLOCK_ENABLED = builder.define("lock_block", true);
            FLAX_ENABLED = builder.define("flax", true);
            ROPE_ENABLED = builder.define("rope", true);
            ROPE_ARROW_ENABLED = builder.define("rope_arrow", true);
            PULLEY_ENABLED = builder.define("pulley_block", true);
            FODDER_ENABLED = builder.define("fodder", true);
            BOMB_ENABLED = builder.define("bomb", true);
            CRIMSON_LANTERN_ENABLED = builder.define("crimson_lantern", true);
            MAGMA_CREAM_BLOCK_ENABLED = builder.define("magma_cream_block", true);
            FLAG_ENABLED = builder.define("flag", true);
            GOBLET_ENABLED = builder.define("goblet", true);
            RAKED_GRAVEL_ENABLED = builder.define("raked_gravel", true);
            FLAG_FORCE_ENABLED = builder.define("i_want_flags", false);
            LASER_ENABLED = builder.comment("WIP").define("laser_block", false);
            builder.pop();
            builder.push("entities");
            FIREFLY_ENABLED = builder.define("firefly", true);
            builder.pop();
            builder.pop();
        }

        static {
            HAS_SILVER = false;
            HAS_BRASS = false;
            HAS_MINESHAFT_LANTERN = false;
            HAS_STRONGHOLD_SCONCE = false;
        }
    }
}

