/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.entities;

import java.util.EnumSet;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.inventories.OrangeMerchantContainer;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.SendOrangeTraderOffersPacket;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtCustomerGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.entity.ai.goal.UseItemGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.ZoglinEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public class OrangeTraderEntity
extends AbstractVillagerEntity {
    @Nullable
    private BlockPos wanderTarget;
    private int despawnDelay;
    public static final VillagerTrades.ITrade[] ORANGE_TRADER_TRADES = new VillagerTrades.ITrade[]{new BasicTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 8), new ItemStack((IItemProvider)Registry.COPPER_LANTERN.get(), 1), 16, 2, 0.05f), new BasicTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 8), new ItemStack((IItemProvider)Registry.ROPE_ITEM.get()), 16, 2, 0.05f), new BasicTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 8), new ItemStack((IItemProvider)Registry.BOMB_ITEM.get()), 16, 2, 0.05f)};

    public OrangeTraderEntity(EntityType<? extends OrangeTraderEntity> type, World world) {
        super(type, world);
        this.field_98038_p = true;
    }

    public OrangeTraderEntity(World world) {
        this(null, world);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new UseItemGoal((MobEntity)this, PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185236_h), SoundEvents.field_219710_mV, p_213733_1_ -> this.field_70170_p.func_226690_K_() && !p_213733_1_.func_82150_aj()));
        this.field_70714_bg.func_75776_a(0, (Goal)new UseItemGoal((MobEntity)this, new ItemStack((IItemProvider)Items.field_151117_aB), SoundEvents.field_219722_na, p_213736_1_ -> this.field_70170_p.func_72935_r() && p_213736_1_.func_82150_aj()));
        this.field_70714_bg.func_75776_a(1, (Goal)new TradeWithPlayerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, ZombieEntity.class, 8.0f, 0.5, 0.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, EvokerEntity.class, 12.0f, 0.5, 0.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, VindicatorEntity.class, 8.0f, 0.5, 0.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, VexEntity.class, 8.0f, 0.5, 0.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, PillagerEntity.class, 15.0f, 0.5, 0.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, IllusionerEntity.class, 12.0f, 0.5, 0.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, ZoglinEntity.class, 10.0f, 0.5, 0.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtCustomerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveToGoal(this, 2.0, 0.35));
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 0.35));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.35));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity entity2) {
        return null;
    }

    public boolean func_213705_dZ() {
        return false;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() != Items.field_196172_da && this.func_70089_S() && !this.func_213716_dX() && !this.func_70631_g_()) {
            if (hand == Hand.MAIN_HAND) {
                player.func_195066_a(Stats.field_188074_H);
            }
            if (!this.func_213706_dY().isEmpty() && !this.field_70170_p.field_72995_K) {
                this.func_70932_a_(player);
                this.func_213707_a(player, this.func_145748_c_(), 1);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_213712_ef() {
        MerchantOffers merchantoffers = this.func_213706_dY();
        this.func_213717_a(merchantoffers, ORANGE_TRADER_TRADES, 5);
    }

    public void func_213707_a(PlayerEntity player, ITextComponent name, int level) {
        MerchantOffers merchantoffers;
        OptionalInt optionalint = player.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((i, p, m) -> new OrangeMerchantContainer(i, p, (IMerchant)this), name));
        if (optionalint.isPresent() && player instanceof ServerPlayerEntity && !(merchantoffers = this.func_213706_dY()).isEmpty()) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SendOrangeTraderOffersPacket(optionalint.getAsInt(), merchantoffers, level, this.func_213708_dV(), this.func_213705_dZ(), this.func_223340_ej()));
        }
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74768_a("DespawnDelay", this.despawnDelay);
        if (this.wanderTarget != null) {
            p_213281_1_.func_218657_a("WanderTarget", (INBT)NBTUtil.func_186859_a((BlockPos)this.wanderTarget));
        }
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        if (p_70037_1_.func_150297_b("DespawnDelay", 99)) {
            this.despawnDelay = p_70037_1_.func_74762_e("DespawnDelay");
        }
        if (p_70037_1_.func_74764_b("WanderTarget")) {
            this.wanderTarget = NBTUtil.func_186861_c((CompoundNBT)p_70037_1_.func_74775_l("WanderTarget"));
        }
        this.func_70873_a(Math.max(0, this.func_70874_b()));
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    protected void func_213713_b(MerchantOffer p_213713_1_) {
        if (p_213713_1_.func_222221_q()) {
            int i = 3 + this.field_70146_Z.nextInt(4);
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    protected SoundEvent func_184639_G() {
        return this.func_213716_dX() ? SoundEvents.field_219723_nb : SoundEvents.field_219708_mT;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_219713_mY;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219709_mU;
    }

    protected SoundEvent func_213351_c(ItemStack p_213351_1_) {
        Item item2 = p_213351_1_.func_77973_b();
        return item2 == Items.field_151117_aB ? SoundEvents.field_219711_mW : SoundEvents.field_219712_mX;
    }

    protected SoundEvent func_213721_r(boolean p_213721_1_) {
        return p_213721_1_ ? SoundEvents.field_219724_nc : SoundEvents.field_219714_mZ;
    }

    public SoundEvent func_213714_ea() {
        return SoundEvents.field_219724_nc;
    }

    public void setDespawnDelay(int p_213728_1_) {
        this.despawnDelay = p_213728_1_;
    }

    public int getDespawnDelay() {
        return this.despawnDelay;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.maybeDespawn();
        }
    }

    private void maybeDespawn() {
        if (this.despawnDelay > 0 && !this.func_213716_dX() && --this.despawnDelay == 0) {
            this.func_70106_y();
        }
    }

    public void setWanderTarget(@Nullable BlockPos p_213726_1_) {
        this.wanderTarget = p_213726_1_;
    }

    @Nullable
    private BlockPos getWanderTarget() {
        return this.wanderTarget;
    }

    class MoveToGoal
    extends Goal {
        final OrangeTraderEntity trader;
        final double stopDistance;
        final double speedModifier;

        MoveToGoal(OrangeTraderEntity p_i50459_2_, double p_i50459_3_, double p_i50459_5_) {
            this.trader = p_i50459_2_;
            this.stopDistance = p_i50459_3_;
            this.speedModifier = p_i50459_5_;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public void func_75251_c() {
            this.trader.setWanderTarget(null);
            OrangeTraderEntity.this.field_70699_by.func_75499_g();
        }

        public boolean func_75250_a() {
            BlockPos blockpos = this.trader.getWanderTarget();
            return blockpos != null && this.isTooFarAway(blockpos, this.stopDistance);
        }

        public void func_75246_d() {
            BlockPos blockpos = this.trader.getWanderTarget();
            if (blockpos != null && OrangeTraderEntity.this.field_70699_by.func_75500_f()) {
                if (this.isTooFarAway(blockpos, 10.0)) {
                    Vector3d vector3d = new Vector3d((double)blockpos.func_177958_n() - this.trader.func_226277_ct_(), (double)blockpos.func_177956_o() - this.trader.func_226278_cu_(), (double)blockpos.func_177952_p() - this.trader.func_226281_cx_()).func_72432_b();
                    Vector3d vector3d1 = vector3d.func_186678_a(10.0).func_72441_c(this.trader.func_226277_ct_(), this.trader.func_226278_cu_(), this.trader.func_226281_cx_());
                    OrangeTraderEntity.this.field_70699_by.func_75492_a(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, this.speedModifier);
                } else {
                    OrangeTraderEntity.this.field_70699_by.func_75492_a((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), this.speedModifier);
                }
            }
        }

        private boolean isTooFarAway(BlockPos p_220846_1_, double p_220846_2_) {
            return !p_220846_1_.func_218137_a((IPosition)this.trader.func_213303_ch(), p_220846_2_);
        }
    }
}

