/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.entities;

import net.mehvahdjukaar.supplementaries.block.blocks.JarBlock;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class ThrowableBrickEntity
extends ProjectileItemEntity
implements IRendersAsItem {
    public ThrowableBrickEntity(EntityType<? extends ThrowableBrickEntity> type, World world) {
        super(type, world);
    }

    public ThrowableBrickEntity(World worldIn, LivingEntity throwerIn) {
        super((EntityType)Registry.THROWABLE_BRICK.get(), throwerIn, worldIn);
    }

    public ThrowableBrickEntity(World worldIn, double x, double y, double z) {
        super((EntityType)Registry.THROWABLE_BRICK.get(), x, y, z, worldIn);
    }

    public ThrowableBrickEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        super((EntityType)Registry.THROWABLE_BRICK.get(), world);
    }

    protected float func_70185_h() {
        return 0.03f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Item func_213885_i() {
        return Items.field_151118_aC;
    }

    private IParticleData makeParticle() {
        ItemStack itemstack = this.func_213882_k();
        return itemstack.func_190926_b() ? new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)this.func_213885_i())) : new ItemParticleData(ParticleTypes.field_197591_B, itemstack);
    }

    public void func_70103_a(byte id) {
        if (id == 3) {
            IParticleData iparticledata = this.makeParticle();
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_195594_a(iparticledata, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void func_230299_a_(BlockRayTraceResult rayTraceResult) {
        super.func_230299_a_(rayTraceResult);
        if (!this.field_70170_p.field_72995_K) {
            Entity entity2 = this.func_234616_v_();
            if (entity2 instanceof PlayerEntity && !((PlayerEntity)entity2).func_175142_cm()) {
                return;
            }
            if (!(entity2 instanceof MobEntity) || this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) || ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.getEntity())) {
                BlockPos pos = rayTraceResult.func_216350_a();
                if (this.field_70170_p.func_180495_p(pos).func_177230_c() instanceof JarBlock) {
                    this.field_70170_p.func_175655_b(pos, true);
                } else {
                    this.breakGlass(pos, 6);
                }
            }
        }
    }

    private static boolean isGlass(BlockState s) {
        try {
            return Tags.Blocks.GLASS_PANES != null && s.func_235714_a_((ITag)Tags.Blocks.GLASS_PANES) || Tags.Blocks.GLASS != null && s.func_235714_a_((ITag)Tags.Blocks.GLASS);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void breakGlass(BlockPos pos, int chance) {
        int c = chance - 1 - this.field_70146_Z.nextInt(4);
        BlockState state = this.field_70170_p.func_180495_p(pos);
        if (state.func_177230_c().func_149638_a() > 3.0f) {
            return;
        }
        if (c < 0 || !ThrowableBrickEntity.isGlass(state)) {
            return;
        }
        this.field_70170_p.func_175655_b(pos, true);
        this.breakGlass(pos.func_177984_a(), c);
        this.breakGlass(pos.func_177977_b(), c);
        this.breakGlass(pos.func_177974_f(), c);
        this.breakGlass(pos.func_177976_e(), c);
        this.breakGlass(pos.func_177978_c(), c);
        this.breakGlass(pos.func_177968_d(), c);
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        super.func_213868_a(p_213868_1_);
        Entity entity2 = p_213868_1_.func_216348_a();
        boolean i = true;
        entity2.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), (float)i);
    }

    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
        if (!this.field_70170_p.field_72995_K) {
            Vector3d v = result.func_216347_e();
            this.field_70170_p.func_184148_a(null, v.field_72450_a, v.field_72448_b, v.field_72449_c, SoundEvents.field_232764_iu_, SoundCategory.NEUTRAL, 0.75f, 1.0f);
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }
}

