/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.events;

import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.block.blocks.DirectionalCakeBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.DoubleCakeBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.RakedGravelBlock;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.PicklePlayer;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.entities.ThrowableBrickEntity;
import net.mehvahdjukaar.supplementaries.items.BlockHolderItem;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.SendLoginMessagePacket;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.mehvahdjukaar.supplementaries.world.data.map.lib.CustomDecorationHolder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BellBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChainBlock;
import net.minecraft.block.EnchantingTableBlock;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class ServerEvents {
    private static ActionResultType paceBlockOverride(Item itemOverride, PlayerEntity player, Hand hand, BlockItem heldItem, BlockPos pos, Direction dir, World world) {
        if (dir != null) {
            ActionResultType activationResult;
            BlockState blockstate = world.func_180495_p(pos);
            BlockRayTraceResult raytrace = new BlockRayTraceResult(new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), dir, pos, false);
            if (!player.func_225608_bj_() && (activationResult = blockstate.func_227031_a_(world, player, hand, raytrace)).func_226246_a_()) {
                return activationResult;
            }
            BlockItemUseContext ctx = new BlockItemUseContext(new ItemUseContext(player, hand, raytrace));
            if (itemOverride instanceof BlockHolderItem) {
                return ((BlockHolderItem)itemOverride).tryPlace(ctx, heldItem.func_179223_d());
            }
            if (itemOverride instanceof BlockItem) {
                return ((BlockItem)itemOverride).func_195942_a(ctx);
            }
        }
        return ActionResultType.PASS;
    }

    public static ActionResultType placeDoubleCake(PlayerEntity player, ItemStack stack, BlockPos pos, World world) {
        boolean d;
        BlockState state1 = world.func_180495_p(pos);
        boolean bl = d = state1.func_177230_c() == Registry.DIRECTIONAL_CAKE.get();
        if (d && (Integer)state1.func_177229_b((Property)DirectionalCakeBlock.field_176589_a) == 0 || state1 == Blocks.field_150414_aQ.func_176223_P()) {
            BlockState state = (BlockState)((BlockState)((Block)Registry.DOUBLE_CAKE.get()).func_176223_P().func_206870_a((Property)DoubleCakeBlock.FACING, (Comparable)(d ? (Direction)state1.func_177229_b((Property)DoubleCakeBlock.FACING) : Direction.WEST))).func_206870_a((Property)DoubleCakeBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a));
            if (!world.func_180501_a(pos, state, 3)) {
                return ActionResultType.FAIL;
            }
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, pos, stack);
            }
            SoundType soundtype = state.getSoundType((IWorldReader)world, pos, (Entity)player);
            world.func_184133_a(player, pos, state.getSoundType((IWorldReader)world, pos, (Entity)player).func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            if (player == null || !player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    private static boolean findConnectedBell(World world, BlockPos pos, PlayerEntity player, int it) {
        if (it > ServerConfigs.cached.BELL_CHAIN_LENGTH) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (b instanceof ChainBlock) {
            return ServerEvents.findConnectedBell(world, pos.func_177984_a(), player, it + 1);
        }
        if (b instanceof BellBlock && it != 0) {
            boolean success = ((BellBlock)b).func_226885_a_(world, pos, ((Direction)state.func_177229_b((Property)BellBlock.field_220133_a)).func_176746_e());
            if (success && player != null) {
                player.func_195066_a(Stats.field_219740_ax);
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block b;
        PlayerEntity player = event.getPlayer();
        if (player.func_175149_v()) {
            return;
        }
        Hand hand = event.getHand();
        ItemStack stack = event.getItemStack();
        Item i = stack.func_77973_b();
        Direction dir = event.getFace();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState blockstate = world.func_180495_p(pos);
        if (i instanceof FilledMapItem && ((b = blockstate.func_177230_c()) instanceof BedBlock || b.func_235332_a_(Blocks.field_235405_no_) || b.func_235332_a_(Blocks.field_150427_aO) || b.func_235332_a_(Blocks.field_150461_bJ) || b.func_235332_a_(Blocks.field_205165_jY) || b.func_235332_a_(Blocks.field_235400_nj_) || b.func_235332_a_(Blocks.field_185775_db) || b.func_235332_a_(Blocks.field_150384_bq))) {
            MapData data;
            if (!world.field_72995_K && (data = FilledMapItem.func_195950_a((ItemStack)stack, (World)world)) instanceof CustomDecorationHolder) {
                ((CustomDecorationHolder)data).toggleCustomDecoration((IWorld)world, pos);
            }
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.field_72995_K));
            return;
        }
        if (!player.func_225608_bj_()) {
            if (ServerConfigs.cached.DIRECTIONAL_CAKE && blockstate == Blocks.field_150414_aQ.func_176223_P() && (!ServerConfigs.cached.DOUBLE_CAKE_PLACEMENT || i != Items.field_222070_lD)) {
                world.func_180501_a(pos, ((Block)Registry.DIRECTIONAL_CAKE.get()).func_176223_P(), 4);
                BlockRayTraceResult raytrace = new BlockRayTraceResult(new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), dir, pos, false);
                event.setCancellationResult(blockstate.func_227031_a_(world, player, hand, raytrace));
                event.setCanceled(true);
                return;
            }
            if (stack.func_190926_b() && hand == Hand.MAIN_HAND && ServerConfigs.cached.BELL_CHAIN) {
                if (ServerEvents.findConnectedBell(world, pos, player, 0)) {
                    event.setCanceled(true);
                    event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.field_72995_K));
                }
                return;
            }
        }
        if (ServerConfigs.cached.BOTTLE_XP && blockstate.func_177230_c() instanceof EnchantingTableBlock && i == Items.field_151069_bo && (player.field_71068_ca > 0 || player.func_184812_l_())) {
            player.func_70097_a(DamageSource.field_76376_m, (float)ServerConfigs.cached.BOTTLING_COST);
            CommonUtil.swapItem(player, hand, new ItemStack((IItemProvider)Items.field_151062_by));
            if (!player.func_184812_l_()) {
                player.func_195068_e(-(3 + world.field_73012_v.nextInt(5) + world.field_73012_v.nextInt(5)));
            }
            if (world.field_72995_K) {
                Minecraft.func_71410_x().field_71452_i.func_199281_a((Entity)player, (IParticleData)Registry.BOTTLING_XP_PARTICLE.get(), 1);
            }
            world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187618_I, SoundCategory.BLOCKS, 1.0f, 1.0f);
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.field_72995_K));
            return;
        }
        if (player.field_71075_bZ.field_75099_e) {
            ActionResultType result = ActionResultType.PASS;
            if (i instanceof BlockItem) {
                BlockItem bi = (BlockItem)i;
                if (ServerConfigs.cached.WALL_LANTERN_PLACEMENT && CommonUtil.isLantern((Item)bi)) {
                    double y;
                    if (CompatHandler.torchslab && (y = event.getHitVec().func_216347_e().func_82617_b() % 1.0) < 0.5) {
                        return;
                    }
                    result = ServerEvents.paceBlockOverride((Item)Registry.WALL_LANTERN_ITEM.get(), player, hand, bi, pos, dir, world);
                } else if (ServerConfigs.cached.HANGING_POT_PLACEMENT && CommonUtil.isPot((Item)bi)) {
                    result = ServerEvents.paceBlockOverride((Item)Registry.HANGING_FLOWER_POT_ITEM.get(), player, hand, bi, pos, dir, world);
                } else if (CommonUtil.isCake((Item)bi)) {
                    if (ServerConfigs.cached.DOUBLE_CAKE_PLACEMENT) {
                        result = ServerEvents.placeDoubleCake(player, stack, pos, world);
                    }
                    if (!result.func_226246_a_() && ServerConfigs.cached.DIRECTIONAL_CAKE) {
                        result = ServerEvents.paceBlockOverride((Item)Registry.DIRECTIONAL_CAKE_ITEM.get(), player, hand, bi, pos, dir, world);
                    }
                }
            }
            if (result.func_226246_a_()) {
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_232607_M_.func_226695_a_((ServerPlayerEntity)player, pos, stack);
                }
                event.setCanceled(true);
                event.setCancellationResult(result);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Hand handIn;
        if (!ServerConfigs.cached.THROWABLE_BRICKS_ENABLED) {
            return;
        }
        PlayerEntity playerIn = event.getPlayer();
        ItemStack itemstack = playerIn.func_184586_b(handIn = event.getHand());
        Item i = itemstack.func_77973_b();
        if (CommonUtil.isBrick(i)) {
            World worldIn = event.getWorld();
            worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187797_fA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (playerIn.func_70681_au().nextFloat() * 0.4f + 0.8f));
            if (!worldIn.field_72995_K) {
                ThrowableBrickEntity brickEntity = new ThrowableBrickEntity(worldIn, (LivingEntity)playerIn);
                brickEntity.func_213884_b(itemstack);
                float pow = 0.7f;
                brickEntity.func_234612_a_((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, 1.5f * pow, 1.0f * pow);
                worldIn.func_217376_c((Entity)brickEntity);
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K));
        }
    }

    @SubscribeEvent
    public static void onHoeUsed(UseHoeEvent event) {
        BlockState raked;
        ItemUseContext context = event.getContext();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (ServerConfigs.cached.RAKED_GRAVEL && world.func_180495_p(pos).func_203425_a(Blocks.field_150351_n) && (raked = ((Block)Registry.RAKED_GRAVEL.get()).func_176223_P()).func_196955_c((IWorldReader)world, pos)) {
            world.func_180501_a(pos, RakedGravelBlock.getConnectedState(raked, world, pos, context.func_195992_f()), 11);
            world.func_184133_a(context.func_195999_j(), pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        try {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new SendLoginMessagePacket());
        }
        catch (Exception exception) {
            Supplementaries.LOGGER.warn("failed to end login message: " + exception);
        }
        PicklePlayer.PickleData.onPlayerLogin(event.getPlayer());
    }
}

