/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.fluids;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.fluids.SoftFluid;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;

public class SoftFluidList {
    public static final HashMap<String, SoftFluid> ID_MAP = new HashMap();
    public static final HashMap<Item, SoftFluid> ITEM_MAP = new HashMap();
    public static final HashMap<Fluid, SoftFluid> FLUID_MAP = new HashMap();
    public static SoftFluid EMPTY = SoftFluidList.makeSF(new SoftFluid.Builder(Fluids.field_204541_a));
    public static SoftFluid WATER;
    public static SoftFluid LAVA;
    public static SoftFluid HONEY;
    public static SoftFluid MILK;
    public static SoftFluid MUSHROOM_STEW;
    public static SoftFluid BEETROOT_SOUP;
    public static SoftFluid RABBIT_STEW;
    public static SoftFluid SUS_STEW;
    public static SoftFluid POTION;
    public static SoftFluid DRAGON_BREATH;
    public static SoftFluid XP;
    public static SoftFluid SLIME;
    public static SoftFluid DIRT;
    public static SoftFluid GHAST_TEAR;
    public static SoftFluid MAGMA_CREAM;
    public static SoftFluid SAP;

    public static SoftFluid fromID(String id) {
        return ID_MAP.getOrDefault(id, EMPTY);
    }

    public static SoftFluid makeSF(SoftFluid.Builder builder) {
        if (builder.isDisabled) {
            return null;
        }
        return new SoftFluid(builder);
    }

    public static void addOpt(List<SoftFluid> l, SoftFluid s) {
        if (s != null) {
            l.add(s);
        }
    }

    public static void init() {
        WATER = SoftFluidList.makeSF(new SoftFluid.Builder((Fluid)Fluids.field_204546_a).food(Items.field_151068_bn));
        LAVA = SoftFluidList.makeSF(new SoftFluid.Builder((Fluid)Fluids.field_204547_b).bottle("alexsmobs:lava_bottle").bucket(Items.field_151129_at).sound(SoundEvents.field_187633_N, SoundEvents.field_187627_L));
        HONEY = SoftFluidList.makeSF(new SoftFluid.Builder(Textures.HONEY_TEXTURE, Textures.HONEY_TEXTURE, "honey").translationKey("fluid.supplementaries.honey").bottle(Items.field_226638_pX_).textureOverrideF("create:honey").addEqFluid("create:honey").addEqFluid("cyclic:honey").addEqFluid("inspirations:honey"));
        MILK = SoftFluidList.makeSF(new SoftFluid.Builder(Textures.MILK_TEXTURE, Textures.POTION_TEXTURE_FLOW, "milk").bucket(Items.field_151117_aB).food(Items.field_151117_aB).translationKey("fluid.supplementaries.milk").textureOverrideF("create:milk").addEqFluid("create:milk").addEqFluid("inspirations:milk").bottle("farmersdelight:milk_bottle").bottle("neapolitan:milk_bottle").bottle("fluffy_farmer:bottle_of_milk").bottle("vanillacookbook:milk_bottle").bottle("simplefarming:milk_bottle").bottle("farmersdelight:milk_bottle"));
        MUSHROOM_STEW = SoftFluidList.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "mushroom_stew").color(16756105).bowl(Items.field_151009_A).addEqFluid("inspirations:mushroom_stew").textureOverrideF("inspirations:mushroom_stew"));
        BEETROOT_SOUP = SoftFluidList.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "beetroot_soup").color(13186100).bowl(Items.field_185165_cW).addEqFluid("inspirations:beetroot_soup").textureOverrideF("inspirations:beetroot_soup"));
        RABBIT_STEW = SoftFluidList.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "rabbit_stew").color(16748623).bowl(Items.field_179560_bq).addEqFluid("inspirations:rabbit_stew").textureOverrideF("inspirations:rabbit_stew"));
        SUS_STEW = SoftFluidList.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "suspicious_stew").color(12249183).bowl(Items.field_222115_pz).textureOverrideF("inspirations:mushroom_stew"));
        POTION = SoftFluidList.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "potion").color(PotionUtils.func_185183_a((Potion)Potions.field_185229_a)).translationKey(Items.field_151068_bn.func_77658_a()).bottle(Items.field_151068_bn).food(Items.field_151068_bn).addEqFluid("create:potion"));
        DRAGON_BREATH = SoftFluidList.makeSF(new SoftFluid.Builder(Textures.DRAGON_BREATH_TEXTURE, Textures.POTION_TEXTURE_FLOW, "dragon_breath").color(0xFF33FF).luminosity(3).translationKey(Items.field_185157_bK.func_77658_a()).bottle(Items.field_185157_bK));
        XP = SoftFluidList.makeSF(new SoftFluid.Builder(Textures.XP_TEXTURE, Textures.XP_TEXTURE_FLOW, "experience").translationKey("fluid.supplementaries.experience").textureOverride("cyclic:xpjuice").addEqFluid("cyclic:xpjuice").bottle(Items.field_151062_by));
        SLIME = SoftFluidList.makeSF(new SoftFluid.Builder(Textures.SLIME_TEXTURE, Textures.SLIME_TEXTURE, "slime").bottle(Items.field_151123_aH).specialEmptyBottle(Items.field_190931_a).emptySound(SoundEvents.field_187884_fr).addEqFluid("cyclic:slime").translationKey("fluid.supplementaries.slime"));
        DIRT = SoftFluidList.makeSF(new SoftFluid.Builder(Textures.DIRT_TEXTURE, Textures.DIRT_TEXTURE, "dirt").bottle(Items.field_221582_j).specialEmptyBottle(Items.field_190931_a).emptySound(SoundEvents.field_187587_bZ).translationKey("block.minecraft.dirt"));
        GHAST_TEAR = SoftFluidList.makeSF(new SoftFluid.Builder(Textures.MILK_TEXTURE, Textures.POTION_TEXTURE_FLOW, "ghast_tear").bottle(Items.field_151073_bk).color(0xBFF0F0).specialEmptyBottle(Items.field_190931_a).translationKey("item.minecraft.ghast_tear"));
        MAGMA_CREAM = SoftFluidList.makeSF(new SoftFluid.Builder(Textures.MAGMA_TEXTURE, Textures.MAGMA_TEXTURE_FLOW, "magma_cream").bottle(Items.field_151064_bs).specialEmptyBottle(Items.field_190931_a).translationKey("item.minecraft.magma_cream"));
        SAP = SoftFluidList.makeSF(new SoftFluid.Builder(Textures.HONEY_TEXTURE, Textures.POTION_TEXTURE_FLOW, "sap").textureOverride("thermal:sap").color(12414506).drink("autumnity:sap_bottle").bucket("thermal:sap_bucket").translationKey("fluid.supplementaries.sap"));
        ArrayList<SoftFluid> custom = new ArrayList<SoftFluid>(Arrays.asList(WATER, LAVA, HONEY, MILK, MUSHROOM_STEW, SUS_STEW, BEETROOT_SOUP, RABBIT_STEW, POTION, DRAGON_BREATH, XP, SLIME, DIRT, GHAST_TEAR, SAP));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "komodo_spit").condition("alexsmobs").color(11057510).translationKey("item.alexmobs.komodo_spit").bottle("alexsmobs:komodo_spit_bottle")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "squash_soup").condition("simplefarming").color(15110922).bowl("simplefarming:squash_soup").food("simplefarming:squash_soup")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder("inspirations:potato_soup").textures(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW).condition("inspirations").bowl("inspirations:potato_soup").food("inspirations:potato_soup")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "fish_oil").condition("alexsmobs").color(16771228).translationKey("item.alexsmobs.fish_oil").food("alexsmobs:fish_oil").bottle("alexsmobs:fish_oil")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "poison").condition("alexsmobs").color(9104231).translationKey("item.alexsmobs:poison").bottle("alexsmobs:poison_bottle")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "sopa_de_macaco").condition("alexsmobs").color(11977092).food("alexsmobs:sopa_de_macaco").bowl("alexsmobs:sopa_de_macaco")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "baked_cod_stew").condition("farmersdelight").color(15519126).food("farmersdelight:baked_cod_stew").bowl("farmersdelight:baked_cod_stew")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "beef_stew").condition("farmersdelight").color(7421741).food("farmersdelight:beef_stew").bowl("farmersdelight:beef_stew")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "chicken_soup").condition("farmersdelight").color(14591846).food("farmersdelight:chicken_soup").bowl("farmersdelight:chicken_soup")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "fish_stew").condition("farmersdelight").color(11748384).food("farmersdelight:fish_stew").bowl("farmersdelight:fish_stew")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.MILK_TEXTURE, Textures.MILK_TEXTURE, "hot_cocoa").condition("farmersdelight").color(9393723).food("farmersdelight:hot_cocoa").translationKey("item.farmersdelight.hot_cocoa").bottle("farmersdelight:hot_cocoa")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "pumpkin_soup").condition("farmersdelight").color(14912029).food("farmersdelight:pumpkin_soup").bowl("farmersdelight:pumpkin_soup")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "tomato_sauce").condition("farmersdelight").color(12596255).food("farmersdelight:tomato_sauce").bowl("farmersdelight:tomato_sauce")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.HONEY_TEXTURE, Textures.POTION_TEXTURE_FLOW, "syrup").condition("autumnity").textureOverride("create:honey").color(9322278).addEqFluid("thermal:syrup").food("autumnity:syrup_bottle").translationKey("item.autumnity.syrup").bottle("autumnity:syrup_bottle")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "fire_stew").condition("iceandfire").color(15424784).food("iceandfire:fire_stew").bowl("iceandfire:fire_stew")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "frost_stew").condition("iceandfire").color(8516345).food("iceandfire:frost_stew").bowl("iceandfire:frost_stew")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "lightning_stew").condition("iceandfire").color(7688898).food("iceandfire:lightning_stew").bowl("iceandfire:lightning_stew")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "fire_dragon_blood").condition("iceandfire").color(15424784).food("iceandfire:fire_dragon_blood").translationKey("item.iceandfire.fire_dragon_blood").bottle("iceandfire:fire_dragon_blood")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "lightning_dragon_blood").condition("iceandfire").color(10944764).food("iceandfire:lightning_dragon_blood").translationKey("item.iceandfire.lightning_dragon_blood").bottle("iceandfire:lightning_dragon_blood")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "ice_dragon_blood").condition("iceandfire").color(1822716).food("iceandfire:ice_dragon_blood").translationKey("item.iceandfire.ice_dragon_blood").bottle("iceandfire:ice_dragon_blood")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.SOUP_TEXTURE, Textures.POTION_TEXTURE_FLOW, "vegetable_soup").condition("farmersdelight").color(9074725).food("farmersdelight:vegetable_soup").bowl("farmersdelight:vegetable_soup")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.MILK_TEXTURE, Textures.MILK_TEXTURE, "goat_milk").condition("betteranimalsplus").translationKey("item.betteranimalsplus.goatmilk").bucket("betteranimalsplus:goatmilk")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "whiskey").condition("simplefarming").color(13799522).translationKey("item.simplefarming.whiskey").food("simplefarming:whiskey").bottle("simplefarming:whiskey")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "olive_oil").condition("simplefarming").color(9871132).translationKey("item.simplefarming.olive_oil").food("simplefarming:olive_oil").bottle("simplefarming:olive_oil")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "vinegar").condition("simplefarming").color(13947588).translationKey("item.simplefarming.vinegar").food("simplefarming:vinegar").bottle("simplefarming:vinegar")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "mead").condition("simplefarming").color(12818192).translationKey("item.simplefarming.mead").food("simplefarming:mead").bottle("simplefarming:mead")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "beer").condition("simplefarming").color(13342791).translationKey("item.simplefarming.beer").food("simplefarming:beer").bottle("simplefarming:beer")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "cauim").condition("simplefarming").color(13615731).translationKey("item.simplefarming.cauim").food("simplefarming:cauim").bottle("simplefarming:cauim")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "cider").condition("simplefarming").color(14455326).translationKey("item.simplefarming.cider").food("simplefarming:cider").bottle("simplefarming:cider")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "sake").condition("simplefarming").color(14931308).translationKey("item.simplefarming.sake").drink("simplefarming:sake")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "tiswin").condition("simplefarming").color(14440486).translationKey("item.simplefarming.tiswin").drink("simplefarming:tiswin")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "vodka").condition("simplefarming").color(13623275).translationKey("item.simplefarming.vodka").drink("simplefarming:vodka")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, "wine").condition("simplefarming").color(9837897).translationKey("item.simplefarming.wine").drink("simplefarming:wine")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.HONEY_TEXTURE, Textures.HONEY_TEXTURE, "jam").condition("simplefarming").color(9899039).translationKey("item.simplefarming.jam").food("simplefarming:jam").bottle("simplefarming:jam")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "umbrella_cluster_juice").condition("betterendforge").color(12473334).translationKey("item.betterendforge.umbrella_cluster_juice").drink("betterendforge:umbrella_cluster_juice")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "soap").condition("fluffy_farmer").color(14393087).translationKey("item.fluffy_farmer.soap").bottle("fluffy_farmer:bottle_with_soap_bubbles")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(Textures.POTION_TEXTURE, Textures.POTION_TEXTURE_FLOW, "soap").condition("betteranimalsplus").color(6334688).translationKey("item.betteranimalsplus.horseshoe_crab_blood").drink("betteranimalsplus:horseshoe_crab_blood")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(new ResourceLocation("tconstruct:sky_congealed_slime"), new ResourceLocation("tconstruct:sky_congealed_slime"), "sky_slime").condition("tconstruct").specialItem("tconstruct:sky_slime_ball").food("tconstruct:sky_slime_ball")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(new ResourceLocation("tconstruct:ichor_congealed_slime"), new ResourceLocation("tconstruct:ichor_congealed_slime"), "ichor_slime").condition("tconstruct").specialItem("tconstruct:ichor_slime_ball").food("tconstruct:ichor_slime_ball")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(new ResourceLocation("tconstruct:blood_congealed_slime"), new ResourceLocation("tconstruct:blood_congealed_slime"), "blood_slime").condition("tconstruct").specialItem("tconstruct:blood_slime_ball").food("tconstruct:blood_slime_ball")));
        SoftFluidList.addOpt(custom, SoftFluidList.makeSF(new SoftFluid.Builder(new ResourceLocation("tconstruct:ender_congealed_slime"), new ResourceLocation("tconstruct:ender_congealed_slime"), "ender_slime").condition("tconstruct").specialItem("tconstruct:ender_slime_ball").food("tconstruct:ender_slime_ball")));
        for (DyeColor c : DyeColor.values()) {
            Item dye = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:" + c.func_176762_d() + "_dye"));
            String name = "inspirations:" + c.func_176610_l() + "_dyed_bottle";
            SoftFluid s = SoftFluidList.makeSF(new SoftFluid.Builder(Textures.WATER_TEXTURE, Textures.FLOWING_WATER_TEXTURE, name).bottle(name).translationKey(dye.func_77658_a()).color(c.getColorValue()).condition("inspirations").textureOverride("inspirations:potato_soup"));
            if (s == null) continue;
            custom.add(s);
        }
        for (SoftFluid s : custom) {
            if (s == null) continue;
            ID_MAP.put(s.getID(), s);
            SoftFluidList.tryAddItems(s.getBowls(), s);
            SoftFluidList.tryAddItems(s.getBottles(), s);
            SoftFluidList.tryAddItems(s.getBuckets(), s);
        }
        ArrayList<SoftFluid> forgeFluidsList = new ArrayList<SoftFluid>();
        for (Fluid f : ForgeRegistries.FLUIDS) {
            try {
                if (f == null || f instanceof FlowingFluid && ((FlowingFluid)f).func_210198_f() != f || f instanceof ForgeFlowingFluid.Flowing || f == Fluids.field_204541_a) continue;
                boolean eq = false;
                for (SoftFluid s : custom) {
                    if (!s.isEquivalent(f)) continue;
                    SoftFluidList.tryAddItem(f.func_204524_b(), s);
                    FLUID_MAP.put(f, s);
                    eq = true;
                    break;
                }
                if (eq) continue;
                SoftFluid newSF = new SoftFluid(new SoftFluid.Builder(f));
                SoftFluidList.tryAddItem(f.func_204524_b(), newSF);
                FLUID_MAP.put(f, newSF);
                forgeFluidsList.add(newSF);
            }
            catch (Exception exception) {}
        }
        for (SoftFluid s : forgeFluidsList) {
            ID_MAP.put(s.getID(), s);
        }
    }

    public static boolean registerModdedSoftFluid(@Nonnull SoftFluid newFluid) {
        boolean override = false;
        if (ID_MAP.containsKey(newFluid.getID())) {
            override = true;
        }
        ID_MAP.put(newFluid.getID(), newFluid);
        boolean o = SoftFluidList.tryAddingItemsStrong(newFluid.getBowls(), newFluid);
        if (o) {
            override = true;
        }
        if (o = SoftFluidList.tryAddingItemsStrong(newFluid.getBottles(), newFluid)) {
            override = true;
        }
        if (o = SoftFluidList.tryAddingItemsStrong(newFluid.getBuckets(), newFluid)) {
            override = true;
        }
        return override;
    }

    private static boolean tryAddingItemsStrong(Collection<Item> c, SoftFluid s) {
        boolean override = false;
        for (Item i : c) {
            if (ITEM_MAP.containsKey(i)) {
                override = true;
            }
            ITEM_MAP.put(i, s);
        }
        return override;
    }

    private static void tryAddItems(Collection<Item> c, SoftFluid s) {
        for (Item i : c) {
            SoftFluidList.tryAddItem(i, s);
        }
    }

    private static void tryAddItem(Item i, SoftFluid s) {
        if (!ITEM_MAP.containsKey(i)) {
            ITEM_MAP.put(i, s);
        }
    }

    public static SoftFluid fromFluid(Fluid fluid) {
        return FLUID_MAP.getOrDefault(fluid, EMPTY);
    }

    public static SoftFluid fromItem(Item item2) {
        return ITEM_MAP.getOrDefault(item2, EMPTY);
    }
}

