/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.items;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.client.renderers.PotionTooltipHelper;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.fluids.SoftFluid;
import net.mehvahdjukaar.supplementaries.fluids.SoftFluidList;
import net.mehvahdjukaar.supplementaries.items.CageItem;
import net.mehvahdjukaar.supplementaries.items.tabs.JarTab;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class JarItem
extends CageItem {
    public JarItem(Block blockIn, Item.Properties properties, Supplier<Item> empty) {
        super(blockIn, properties, empty);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt != null) {
            if (compoundnbt.func_150297_b("LootTable", 8)) {
                tooltip.add((ITextComponent)new StringTextComponent("???????").func_240699_a_(TextFormatting.GRAY));
            }
            if (compoundnbt.func_74764_b("FluidHolder")) {
                CompoundNBT com = compoundnbt.func_74775_l("FluidHolder");
                SoftFluid s = SoftFluidList.fromID(com.func_74779_i("Fluid"));
                int count = com.func_74762_e("Count");
                if (!s.isEmpty() && count > 0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("message.supplementaries.fluid_tooltip", new Object[]{s.getTranslatedName(), count}).func_240699_a_(TextFormatting.GRAY));
                    if (com.func_74764_b("NBT") && com.func_74775_l("NBT").func_74764_b("Potion")) {
                        PotionTooltipHelper.addPotionTooltip(com.func_74775_l("NBT"), tooltip, 1.0f);
                        return;
                    }
                }
            }
            if (compoundnbt.func_150297_b("Items", 9)) {
                NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((CompoundNBT)compoundnbt, (NonNullList)nonnulllist);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.func_190926_b()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    IFormattableTextComponent iformattabletextcomponent = itemstack.func_200301_q().func_230532_e_();
                    String s = iformattabletextcomponent.getString();
                    s = s.replace(" Bucket", "");
                    s = s.replace(" Bottle", "");
                    s = s.replace("Bucket of ", "");
                    StringTextComponent str = new StringTextComponent(s);
                    str.func_240702_b_(" x").func_240702_b_(String.valueOf(itemstack.func_190916_E()));
                    tooltip.add((ITextComponent)str.func_240699_a_(TextFormatting.GRAY));
                }
                if (j - i > 0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("container.shulkerBox.more", new Object[]{j - i}).func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
                }
            }
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group) && ((Boolean)RegistryConfigs.reg.JAR_TAB.get()).booleanValue() && group == Registry.JAR_TAB) {
            JarTab.populateTab(items);
        }
    }

    public Rarity func_77613_e(ItemStack stack) {
        CompoundNBT com;
        SoftFluid s;
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt != null && compoundnbt.func_74764_b("FluidHolder") && (s = SoftFluidList.fromID((com = compoundnbt.func_74775_l("FluidHolder")).func_74779_i("Fluid"))) == SoftFluidList.DIRT) {
            return Rarity.RARE;
        }
        return super.func_77613_e(stack);
    }
}

