/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import net.mehvahdjukaar.supplementaries.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.block.util.IBellConnection;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BellBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChainBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BellBlock.class})
public abstract class BellBlockMixin
extends Block {
    public BellBlockMixin(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean tryConnect(BlockPos pos, BlockState facingState, IWorld world) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IBellConnection) {
            IBellConnection.BellConnection connection = IBellConnection.BellConnection.NONE;
            if (facingState.func_177230_c() instanceof ChainBlock && facingState.func_177229_b((Property)ChainBlock.field_176298_M) == Direction.Axis.Y) {
                connection = IBellConnection.BellConnection.CHAIN;
            } else if (facingState.func_177230_c() instanceof RopeBlock) {
                connection = IBellConnection.BellConnection.ROPE;
            }
            ((IBellConnection)te).setConnected(connection);
            te.func_70296_d();
            return true;
        }
        return false;
    }

    @Inject(method={"updateShape"}, at={@At(value="HEAD")}, cancellable=true)
    public void updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos, CallbackInfoReturnable<BlockState> info) {
        try {
            if (facing == Direction.DOWN && this.tryConnect(currentPos, facingState, worldIn) && worldIn instanceof World) {
                ((World)worldIn).func_184138_a(currentPos, stateIn, stateIn, 2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        this.tryConnect(pos, worldIn.func_180495_p(pos.func_177977_b()), (IWorld)worldIn);
    }
}

