/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.network;

import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.world.data.map.lib.CustomDecoration;
import net.mehvahdjukaar.supplementaries.world.data.map.lib.CustomDecorationHolder;
import net.mehvahdjukaar.supplementaries.world.data.map.lib.CustomDecorationType;
import net.mehvahdjukaar.supplementaries.world.data.map.lib.MapDecorationHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.item.FilledMapItem;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncCustomMapDecorationPacket {
    private final int mapId;
    private final CustomDecoration[] customDecoration;

    public SyncCustomMapDecorationPacket(int mapId, CustomDecoration[] customDecoration) {
        this.mapId = mapId;
        this.customDecoration = customDecoration;
    }

    public SyncCustomMapDecorationPacket(PacketBuffer buffer) {
        this.mapId = buffer.func_150792_a();
        this.customDecoration = new CustomDecoration[buffer.func_150792_a()];
        for (int i = 0; i < this.customDecoration.length; ++i) {
            CustomDecorationType<?, ?> type = MapDecorationHandler.get(buffer.func_192575_l());
            this.customDecoration[i] = type.loadDecorationFromBuffer(buffer);
        }
    }

    public static void buffer(SyncCustomMapDecorationPacket message, PacketBuffer buffer) {
        buffer.func_150787_b(message.mapId);
        buffer.func_150787_b(message.customDecoration.length);
        for (CustomDecoration decoration : message.customDecoration) {
            buffer.func_192572_a(decoration.getType().getId());
            decoration.saveToBuffer(buffer);
        }
    }

    public static void handler(SyncCustomMapDecorationPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                Minecraft mc = Minecraft.func_71410_x();
                MapItemRenderer mapitemrenderer = mc.field_71460_t.func_147701_i();
                String s = FilledMapItem.func_219993_a((int)message.getMapId());
                MapData mapdata = mc.field_71441_e.func_217406_a(s);
                if (mapdata == null) {
                    MapData mapdata1;
                    mapdata = new MapData(s);
                    if (mapitemrenderer.func_191205_a(s) != null && (mapdata1 = mapitemrenderer.func_191207_a(mapitemrenderer.func_191205_a(s))) != null) {
                        mapdata = mapdata1;
                    }
                    mc.field_71441_e.func_217399_a(mapdata);
                }
                message.applyToMap(mapdata);
                mapitemrenderer.func_148246_a(mapdata);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getMapId() {
        return this.mapId;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void applyToMap(MapData data) {
        if (data instanceof CustomDecorationHolder) {
            Map<String, CustomDecoration> decorations = ((CustomDecorationHolder)data).getCustomDecorations();
            decorations.clear();
            for (int i = 0; i < this.customDecoration.length; ++i) {
                CustomDecoration mapdecoration = this.customDecoration[i];
                decorations.put("icon-" + i, mapdecoration);
            }
        }
    }
}

