/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.block.tiles.SpeakerBlockTile;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateServerSpeakerBlockPacket {
    private final BlockPos pos;
    private final ITextComponent str;
    private final boolean narrator;
    private final double volume;

    public UpdateServerSpeakerBlockPacket(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.str = buf.func_179258_d();
        this.narrator = buf.readBoolean();
        this.volume = buf.readDouble();
    }

    public UpdateServerSpeakerBlockPacket(BlockPos pos, String str, boolean narrator, double volume) {
        this.pos = pos;
        this.str = new StringTextComponent(str);
        this.narrator = narrator;
        this.volume = volume;
    }

    public static void buffer(UpdateServerSpeakerBlockPacket message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.func_179256_a(message.str);
        buf.writeBoolean(message.narrator);
        buf.writeDouble(message.volume);
    }

    public static void handler(UpdateServerSpeakerBlockPacket message, Supplier<NetworkEvent.Context> ctx) {
        World world = Objects.requireNonNull(ctx.get().getSender()).field_70170_p;
        ctx.get().enqueueWork(() -> {
            TileEntity tileentity;
            if (world != null && (tileentity = world.func_175625_s(message.pos)) instanceof SpeakerBlockTile) {
                SpeakerBlockTile speaker = (SpeakerBlockTile)tileentity;
                speaker.message = message.str.getString();
                speaker.narrator = message.narrator;
                speaker.volume = message.volume;
                tileentity.func_70296_d();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

