/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.setup;

import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.block.blocks.BambooSpikesBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.FireflyJarBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.LightUpBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.block.util.CapturedMobs;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.entities.ThrowableBrickEntity;
import net.mehvahdjukaar.supplementaries.fluids.SoftFluidList;
import net.mehvahdjukaar.supplementaries.items.EmptyJarItem;
import net.mehvahdjukaar.supplementaries.items.JarItem;
import net.mehvahdjukaar.supplementaries.items.SackItem;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.FishBucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class Dispenser {
    public static Map<Item, IDispenseItemBehavior> DEFAULT_BEHAVIORS;
    private static final DefaultDispenseItemBehavior spawneggBehavior;
    private static final DefaultDispenseItemBehavior shootBehavior;

    public static void registerBehaviors() {
        if (!((Boolean)RegistryConfigs.reg.DISPENSERS.get()).booleanValue()) {
            return;
        }
        DEFAULT_BEHAVIORS = new HashMap<Item, IDispenseItemBehavior>(DispenserBlock.field_149943_a);
        if (DEFAULT_BEHAVIORS == null) {
            Supplementaries.LOGGER.info("Failed to register dispenser behaviors");
            return;
        }
        if (((Boolean)RegistryConfigs.reg.JAR_ENABLED.get()).booleanValue()) {
            for (Item item2 : ForgeRegistries.ITEMS) {
                if (item2 instanceof JarItem || item2 instanceof EmptyJarItem || item2 instanceof SackItem || item2 instanceof BlockItem && ((BlockItem)item2).func_179223_d() instanceof FireflyJarBlock) {
                    DispenserBlock.func_199774_a((IItemProvider)item2, (IDispenseItemBehavior)new PlaceBlockDispenseBehavior());
                    continue;
                }
                if (!(item2 instanceof FishBucketItem) && item2 != Items.field_151106_aX && item2 != Items.field_151131_as && !SoftFluidList.ITEM_MAP.containsKey(item2)) continue;
                DispenserBlock.func_199774_a((IItemProvider)item2, (IDispenseItemBehavior)new FillJarDispenserBehavior());
            }
            DispenserBlock.func_199774_a((IItemProvider)Items.field_151133_ar, (IDispenseItemBehavior)new BucketJarDispenserBehavior());
            DispenserBlock.func_199774_a((IItemProvider)Items.field_151054_z, (IDispenseItemBehavior)new BucketJarDispenserBehavior());
            DispenserBlock.func_199774_a((IItemProvider)Items.field_151069_bo, (IDispenseItemBehavior)new BucketJarDispenserBehavior());
            for (Item i : CapturedMobs.VALID_BUCKETS.keySet()) {
                DispenserBlock.func_199774_a((IItemProvider)i, (IDispenseItemBehavior)new FishBucketJarDispenserBehavior());
            }
        }
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151033_d, (IDispenseItemBehavior)new FlintAndSteelDispenserBehavior());
        DispenserBlock.func_199774_a((IItemProvider)Items.field_185156_bI, (IDispenseItemBehavior)new BambooSpikesDispenserBehavior());
        if (ServerConfigs.cached.THROWABLE_BRICKS_ENABLED) {
            DispenserBlock.func_199774_a((IItemProvider)Items.field_196154_dH, (IDispenseItemBehavior)new ThrowableBricksDispenserBehavior((ITag<Item>)ModTags.BRICKS));
            DispenserBlock.func_199774_a((IItemProvider)Items.field_151118_aC, (IDispenseItemBehavior)new ThrowableBricksDispenserBehavior((ITag<Item>)ModTags.BRICKS));
        }
        if (((Boolean)RegistryConfigs.reg.FIREFLY_ENABLED.get()).booleanValue()) {
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)Registry.FIREFLY_SPAWN_EGG_ITEM.get()), (IDispenseItemBehavior)spawneggBehavior);
        }
        if (((Boolean)RegistryConfigs.reg.BOMB_ENABLED.get()).booleanValue()) {
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)Registry.BOMB_ITEM.get()), (IDispenseItemBehavior)new BombsDispenserBehavior());
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)Registry.BOMB_BLUE_ITEM.get()), (IDispenseItemBehavior)new BombsDispenserBehavior());
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)Registry.BOMB_ITEM_ON.get()), (IDispenseItemBehavior)new BombsDispenserBehavior());
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)Registry.BOMB_BLUE_ITEM_ON.get()), (IDispenseItemBehavior)new BombsDispenserBehavior());
        }
    }

    private static boolean MergeDispenserItem(DispenserTileEntity te, ItemStack filled) {
        NonNullList stacks = te.field_146022_i;
        for (int i = 0; i < te.func_70302_i_(); ++i) {
            ItemStack s = (ItemStack)stacks.get(i);
            if (!s.func_190926_b() && (s.func_77973_b() != filled.func_77973_b() || s.func_77976_d() <= s.func_190916_E())) continue;
            filled.func_190917_f(s.func_190916_E());
            te.func_70299_a(i, filled);
            return true;
        }
        return false;
    }

    private static ItemStack glassBottleFill(IBlockSource source, ItemStack empty, ItemStack filled) {
        empty.func_190918_g(1);
        if (empty.func_190926_b()) {
            return filled.func_77946_l();
        }
        if (!Dispenser.MergeDispenserItem((DispenserTileEntity)source.func_150835_j(), filled)) {
            shootBehavior.dispense(source, filled.func_77946_l());
        }
        return empty;
    }

    static {
        spawneggBehavior = new DefaultDispenseItemBehavior(){

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                EntityType entitytype = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
                entitytype.func_220331_a(source.func_197524_h(), stack, null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
                stack.func_190918_g(1);
                return stack;
            }
        };
        shootBehavior = new DefaultDispenseItemBehavior();
    }

    private static class PlaceBlockDispenseBehavior
    extends OptionalDispenseBehavior {
        private PlaceBlockDispenseBehavior() {
        }

        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            this.func_239796_a_(false);
            Item item2 = stack.func_77973_b();
            if (item2 instanceof BlockItem) {
                Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                BlockPos blockpos = source.func_180699_d().func_177972_a(direction);
                Direction direction1 = source.func_197524_h().func_175623_d(blockpos.func_177977_b()) ? direction : Direction.UP;
                ActionResultType result = ((BlockItem)item2).func_195942_a((BlockItemUseContext)new DirectionalPlaceContext((World)source.func_197524_h(), blockpos, direction, stack, direction1));
                this.func_239796_a_(result.func_226246_a_());
            }
            return stack;
        }
    }

    private static class BucketJarDispenserBehavior
    extends AdditionalDispenserBehavior {
        private BucketJarDispenserBehavior() {
        }

        @Override
        protected ItemStack customBehavior(IBlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerWorld world = source.func_197524_h();
            TileEntity te = world.func_175625_s(blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a)));
            if (te instanceof JarBlockTile) {
                ItemStack returnStack;
                JarBlockTile tile = (JarBlockTile)te;
                if (tile.func_191420_l() && tile.mobHolder.isEmpty() && tile.func_191420_l() && (returnStack = tile.fluidHolder.interactWithItem(stack)) != null && !returnStack.func_190926_b()) {
                    tile.func_70296_d();
                    return Dispenser.glassBottleFill(source, stack, returnStack);
                }
                return stack;
            }
            return super.customBehavior(source, stack);
        }
    }

    private static class FishBucketJarDispenserBehavior
    extends AdditionalDispenserBehavior {
        private FishBucketJarDispenserBehavior() {
        }

        @Override
        protected ItemStack customBehavior(IBlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerWorld world = source.func_197524_h();
            TileEntity te = world.func_175625_s(blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a)));
            if (te instanceof JarBlockTile) {
                JarBlockTile tile = (JarBlockTile)te;
                if (tile.fluidHolder.isEmpty() && tile.func_191420_l() && tile.mobHolder.interactWithBucketItem(stack, null, null)) {
                    tile.func_70296_d();
                    return Dispenser.glassBottleFill(source, stack, new ItemStack((IItemProvider)Items.field_151133_ar));
                }
                return stack;
            }
            return super.customBehavior(source, stack);
        }
    }

    private static class BambooSpikesDispenserBehavior
    extends AdditionalDispenserBehavior {
        private BambooSpikesDispenserBehavior() {
        }

        @Override
        protected ItemStack customBehavior(IBlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerWorld world = source.func_197524_h();
            BlockState state = world.func_180495_p(blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a)));
            if (state.func_177230_c() instanceof BambooSpikesBlock) {
                if (BambooSpikesBlock.tryAddingPotion(state, (IWorld)world, blockpos, stack)) {
                    return Dispenser.glassBottleFill(source, stack, new ItemStack((IItemProvider)Items.field_151069_bo));
                }
                return stack;
            }
            return super.customBehavior(source, stack);
        }
    }

    private static class BombsDispenserBehavior
    extends ProjectileDispenseBehavior {
        private BombsDispenserBehavior() {
        }

        protected ProjectileEntity func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
            return new BombEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
        }

        protected float func_82498_a() {
            return 11.0f;
        }

        protected float func_82500_b() {
            return 1.3f;
        }
    }

    private static class ThrowableBricksDispenserBehavior
    extends TaggedAdditionalDispenserBehavior {
        ThrowableBricksDispenserBehavior(ITag<Item> tag) {
            super(tag);
        }

        @Override
        protected ItemStack customBehavior(IBlockSource source, ItemStack stack) {
            ServerWorld world = source.func_197524_h();
            IPosition iposition = DispenserBlock.func_149939_a((IBlockSource)source);
            Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            ProjectileEntity projectileentity = this.getProjectileEntity((World)world, iposition, stack);
            projectileentity.func_70186_c((double)direction.func_82601_c(), (double)((float)direction.func_96559_d() + 0.1f), (double)direction.func_82599_e(), this.getProjectileVelocity(), this.getProjectileInaccuracy());
            world.func_217376_c((Entity)projectileentity);
            stack.func_190918_g(1);
            return stack;
        }

        protected void func_82485_a(IBlockSource source) {
            source.func_197524_h().func_184148_a(null, source.func_82615_a() + 0.5, source.func_82617_b() + 0.5, source.func_82616_c() + 0.5, SoundEvents.field_187797_fA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (source.func_197524_h().func_201674_k().nextFloat() * 0.4f + 0.8f));
        }

        protected ProjectileEntity getProjectileEntity(World worldIn, IPosition position, ItemStack stackIn) {
            return new ThrowableBrickEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
        }

        protected float getProjectileInaccuracy() {
            return 7.0f;
        }

        protected float getProjectileVelocity() {
            return 0.9f;
        }
    }

    private static class FlintAndSteelDispenserBehavior
    extends AdditionalDispenserBehavior {
        private FlintAndSteelDispenserBehavior() {
        }

        @Override
        protected ItemStack customBehavior(IBlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerWorld world = source.func_197524_h();
            BlockState state = world.func_180495_p(blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a)));
            if (state.func_177230_c() instanceof LightUpBlock) {
                if (LightUpBlock.lightUp(state, blockpos, (IWorld)world, LightUpBlock.FireSound.FLINT_AND_STEEL) && stack.func_96631_a(1, world.field_73012_v, (ServerPlayerEntity)null)) {
                    stack.func_190920_e(0);
                }
                return stack;
            }
            return super.customBehavior(source, stack);
        }
    }

    private static class FillJarDispenserBehavior
    extends AdditionalDispenserBehavior {
        private FillJarDispenserBehavior() {
        }

        @Override
        protected ItemStack customBehavior(IBlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerWorld world = source.func_197524_h();
            TileEntity te = world.func_175625_s(blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a)));
            if (te instanceof JarBlockTile) {
                JarBlockTile tile = (JarBlockTile)te;
                if (tile.mobHolder.isEmpty()) {
                    ItemStack returnStack;
                    if (tile.func_94041_b(0, stack)) {
                        tile.handleAddItem(stack, null, null);
                        tile.func_70296_d();
                        return Dispenser.glassBottleFill(source, stack, ItemStack.field_190927_a);
                    }
                    if (tile.func_191420_l() && !tile.fluidHolder.isFull() && (returnStack = tile.fluidHolder.interactWithItem(stack)) != null && !returnStack.func_190926_b()) {
                        tile.func_70296_d();
                        return Dispenser.glassBottleFill(source, stack, returnStack);
                    }
                }
                return stack;
            }
            return super.customBehavior(source, stack);
        }
    }

    private static abstract class AdditionalDispenserBehavior
    extends DefaultDispenseItemBehavior {
        private AdditionalDispenserBehavior() {
        }

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            try {
                return this.customBehavior(source, stack);
            }
            catch (Exception e) {
                return shootBehavior.dispense(source, stack);
            }
        }

        protected ItemStack customBehavior(IBlockSource source, ItemStack stack) {
            return DEFAULT_BEHAVIORS.get(stack.func_77973_b()).dispense(source, stack);
        }
    }

    private static abstract class TaggedAdditionalDispenserBehavior
    extends AdditionalDispenserBehavior {
        private final ITag<Item> tag;

        TaggedAdditionalDispenserBehavior(ITag<Item> tag) {
            this.tag = tag;
        }

        @Override
        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            if (ModTags.isTagged(this.tag, stack.func_77973_b())) {
                return super.func_82487_b(source, stack);
            }
            return super.customBehavior(source, stack);
        }

        @Override
        protected abstract ItemStack customBehavior(IBlockSource var1, ItemStack var2);
    }
}

