/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.setup;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.mehvahdjukaar.supplementaries.block.util.CapturedMobs;
import net.mehvahdjukaar.supplementaries.common.AdventurerMapsHandler;
import net.mehvahdjukaar.supplementaries.common.FlowerPotHelper;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.fluids.SoftFluidList;
import net.mehvahdjukaar.supplementaries.mixins.accessors.ChickenEntityAccessor;
import net.mehvahdjukaar.supplementaries.mixins.accessors.HorseEntityAccessor;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.commands.ModCommands;
import net.mehvahdjukaar.supplementaries.setup.Dispenser;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.mehvahdjukaar.supplementaries.setup.Spawns;
import net.mehvahdjukaar.supplementaries.world.structures.StructureLocator;
import net.mehvahdjukaar.supplementaries.world.structures.StructureRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="supplementaries", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModSetup {
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            NetworkHandler.registerMessages();
            Spawns.registerSpawningStuff();
            ComposterBlock.field_220299_b.put((Object)((Item)Registry.FLAX_SEEDS_ITEM.get()).func_199767_j(), 0.3f);
            ComposterBlock.field_220299_b.put((Object)((Item)Registry.FLAX_ITEM.get()).func_199767_j(), 0.65f);
            ComposterBlock.field_220299_b.put((Object)((Block)Registry.FLAX_BLOCK.get()).func_199767_j(), 1.0f);
            ArrayList<ItemStack> chickenFood = new ArrayList<ItemStack>();
            Collections.addAll(chickenFood, ChickenEntityAccessor.getFoodItems().func_193365_a());
            chickenFood.add(new ItemStack((IItemProvider)Registry.FLAX_SEEDS_ITEM.get()));
            ChickenEntityAccessor.setFoodItems(Ingredient.func_234819_a_(chickenFood.stream()));
            ArrayList<ItemStack> horseFood = new ArrayList<ItemStack>();
            Collections.addAll(horseFood, HorseEntityAccessor.getFoodItems().func_193365_a());
            horseFood.add(new ItemStack((IItemProvider)Registry.FLAX_ITEM.get()));
            horseFood.add(new ItemStack((IItemProvider)Registry.FLAX_BLOCK_ITEM.get()));
            HorseEntityAccessor.setFoodItems(Ingredient.func_234819_a_(horseFood.stream()));
            CompatHandler.init();
            ((FlowerPotBlock)Blocks.field_150457_bL).addPlant(((Item)Registry.FLAX_ITEM.get()).getRegistryName(), Registry.FLAX_POT);
            FlowerPotHelper.init();
            SoftFluidList.init();
            CapturedMobs.refresh();
            Dispenser.registerBehaviors();
            StructureRegistry.setup();
            StructureLocator.init();
        });
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void villagerTradesEvent(VillagerTradesEvent ev) {
        if (((Boolean)RegistryConfigs.reg.FLAX_ENABLED.get()).booleanValue() && ev.getType().equals(VillagerProfession.field_221156_f)) {
            ((List)ev.getTrades().get(3)).add(new BasicTrade(new ItemStack((IItemProvider)Registry.FLAX_SEEDS_ITEM.get(), 15), new ItemStack((IItemProvider)Items.field_151166_bC), 16, 2, 0.05f));
        }
        AdventurerMapsHandler.addTrades(ev);
    }

    @SubscribeEvent
    public static void registerWanderingTraderTrades(WandererTradesEvent event) {
        int i;
        if (((Boolean)RegistryConfigs.reg.GLOBE_ENABLED.get()).booleanValue()) {
            for (i = 0; i < ServerConfigs.cached.GLOBE_TRADES; ++i) {
                event.getRareTrades().add(new BasicTrade(10, new ItemStack((IItemProvider)Registry.GLOBE_ITEM.get(), 1), 3, 20));
            }
        }
        if (((Boolean)RegistryConfigs.reg.FLAX_ENABLED.get()).booleanValue()) {
            for (i = 0; i < 3; ++i) {
                event.getGenericTrades().add(new BasicTrade(6, new ItemStack((IItemProvider)Registry.FLAX_SEEDS_ITEM.get(), 1), 5, 10));
            }
        }
    }

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent e) {
        String name = e.getName().toString();
        if (name.equals("minecraft:chests/shipwreck_treasure")) {
            if (!((Boolean)RegistryConfigs.reg.GLOBE_ENABLED.get()).booleanValue()) {
                return;
            }
            float chance = (float)ServerConfigs.cached.GLOBE_TREASURE_CHANCE;
            LootPool pool = LootPool.func_216096_a().name("supplementaries_injected_globe").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(RandomChance.func_216004_a((float)chance)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)Registry.GLOBE_ITEM.get())).func_216086_a(1)).func_216044_b();
            e.getTable().addPool(pool);
        } else if (name.equals("minecraft:chests/abandoned_mineshaft") || name.contains("repurposed_structures:chests/mineshaft")) {
            if (((Boolean)RegistryConfigs.reg.ROPE_ENABLED.get()).booleanValue()) {
                float chance = 0.35f;
                LootPool pool = LootPool.func_216096_a().name("supplementaries_injected_rope").func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)4.0f, (float)8.0f))).func_216046_a((IRandomRange)new RandomValueRange(1.0f, 2.0f)).func_212840_b_(RandomChance.func_216004_a((float)chance)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)Registry.ROPE_ITEM.get())).func_216086_a(1)).func_216044_b();
                e.getTable().addPool(pool);
            }
            if (((Boolean)RegistryConfigs.reg.FLAX_ENABLED.get()).booleanValue()) {
                float chance2 = 0.1f;
                LootPool pool2 = LootPool.func_216096_a().name("supplementaries_injected_flax").func_216046_a((IRandomRange)new RandomValueRange(1.0f, 3.0f)).func_212840_b_(RandomChance.func_216004_a((float)chance2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)Registry.FLAX_SEEDS_ITEM.get())).func_216086_a(1)).func_216044_b();
                e.getTable().addPool(pool2);
            }
        } else if (name.equals("minecraft:chests/simple_dungeon") || name.contains("repurposed_structures:chests/dungeon")) {
            if (!((Boolean)RegistryConfigs.reg.FLAX_ENABLED.get()).booleanValue()) {
                return;
            }
            float chance = 0.2f;
            LootPool pool = LootPool.func_216096_a().name("supplementaries_injected_flax").func_216046_a((IRandomRange)new RandomValueRange(1.0f, 3.0f)).func_212840_b_(RandomChance.func_216004_a((float)chance)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)Registry.FLAX_SEEDS_ITEM.get())).func_216086_a(1)).func_216044_b();
            e.getTable().addPool(pool);
        } else if (name.contains("chests/pillager_outpost")) {
            if (!((Boolean)RegistryConfigs.reg.FLAX_ENABLED.get()).booleanValue()) {
                return;
            }
            float chance = 0.95f;
            LootPool pool = LootPool.func_216096_a().name("supplementaries_injected_flax").func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)5.0f))).func_212840_b_(RandomChance.func_216004_a((float)chance)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)Registry.FLAX_SEEDS_ITEM.get())).func_216086_a(1)).func_216044_b();
            e.getTable().addPool(pool);
        }
    }
}

