/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.world.data.map.lib;

import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.world.data.map.lib.CustomDecoration;
import net.mehvahdjukaar.supplementaries.world.data.map.lib.MapWorldMarker;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class CustomDecorationType<D extends CustomDecoration, M extends MapWorldMarker<D>> {
    private final ResourceLocation id;
    private final Function<CompoundNBT, M> loadMarker;
    private final BiFunction<IBlockReader, BlockPos, M> fromWorld;
    private final BiFunction<CustomDecorationType<?, ?>, PacketBuffer, D> decoFromBuffer;
    private final boolean hasMarker;

    public CustomDecorationType(ResourceLocation id, Function<CompoundNBT, M> loadMarkerFromNBT, BiFunction<IBlockReader, BlockPos, M> getWorldMarkerFromWorld, BiFunction<CustomDecorationType<?, ?>, PacketBuffer, D> decoFromBuffer) {
        this.id = id;
        this.loadMarker = loadMarkerFromNBT;
        this.fromWorld = getWorldMarkerFromWorld;
        this.decoFromBuffer = decoFromBuffer;
        this.hasMarker = true;
    }

    public CustomDecorationType(ResourceLocation id, BiFunction<CustomDecorationType<?, ?>, PacketBuffer, D> decoFromBuffer) {
        this.id = id;
        this.loadMarker = s -> null;
        this.fromWorld = (s, d) -> null;
        this.decoFromBuffer = decoFromBuffer;
        this.hasMarker = false;
    }

    public boolean hasMarker() {
        return this.hasMarker;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getSerializeId() {
        return this.id.toString();
    }

    @Nullable
    public M loadWorldMarkerFromNBT(CompoundNBT compound) {
        return (M)(this.hasMarker ? (MapWorldMarker)this.loadMarker.apply(compound) : null);
    }

    @Nullable
    public M getWorldMarkerFromWorld(IBlockReader reader, BlockPos pos) {
        return (M)(this.hasMarker ? (MapWorldMarker)this.fromWorld.apply(reader, pos) : null);
    }

    @Nullable
    public D loadDecorationFromBuffer(PacketBuffer buffer) {
        return (D)((CustomDecoration)this.decoFromBuffer.apply(this, buffer));
    }
}

