/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.world.data.map.lib;

import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.world.data.map.lib.CustomDecoration;
import net.mehvahdjukaar.supplementaries.world.data.map.lib.CustomDecorationType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class MapWorldMarker<D extends CustomDecoration> {
    private final CustomDecorationType<D, ?> type;
    private final BlockPos pos;

    public MapWorldMarker(CustomDecorationType<D, ?> type, BlockPos pos) {
        this.type = type;
        this.pos = pos;
    }

    public CustomDecorationType<D, ?> getType() {
        return this.type;
    }

    public String getTypeId() {
        return this.type.getSerializeId();
    }

    private String getPosId() {
        return this.pos.func_177958_n() + "," + this.pos.func_177956_o() + "," + this.pos.func_177952_p();
    }

    public String getMarkerId() {
        return this.getTypeId() + "-" + this.getPosId();
    }

    public abstract CompoundNBT saveToNBT();

    public BlockPos getPos() {
        return this.pos;
    }

    public int getRotation() {
        return 0;
    }

    @Nullable
    protected abstract D doCreateDecoration(byte var1, byte var2, byte var3);

    @Nullable
    public D createDecorationFromMarker(byte scale, int x, int z, RegistryKey<World> dimension, boolean locked) {
        double worldX = this.getPos().func_177958_n();
        double worldZ = this.getPos().func_177952_p();
        double rotation = this.getRotation();
        int i = 1 << scale;
        float f = (float)(worldX - (double)x) / (float)i;
        float f1 = (float)(worldZ - (double)z) / (float)i;
        byte mapX = (byte)((double)(f * 2.0f) + 0.5);
        byte mapY = (byte)((double)(f1 * 2.0f) + 0.5);
        if (f >= -63.0f && f1 >= -63.0f && f <= 63.0f && f1 <= 63.0f) {
            byte rot = (byte)((rotation += rotation < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            return this.doCreateDecoration(mapX, mapY, rot);
        }
        return null;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public boolean shouldUpdate(MapWorldMarker<?> other) {
        return false;
    }

    public CustomDecoration updateDecoration(CustomDecoration old) {
        return old;
    }
}

