/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.world.data.map.lib.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.world.data.map.lib.CustomDecoration;
import net.mehvahdjukaar.supplementaries.world.data.map.lib.CustomDecorationType;
import net.mehvahdjukaar.supplementaries.world.data.map.lib.client.DecorationRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.MapData;

public class MapDecorationClient {
    private static final Map<CustomDecorationType<?, ?>, DecorationRenderer<?>> RENDERERS = Maps.newHashMap();

    public static <T extends CustomDecoration> void bindDecorationRenderer(CustomDecorationType<T, ?> type, DecorationRenderer<T> renderer) {
        if (RENDERERS.containsKey(type)) {
            throw new IllegalArgumentException("Duplicate map decoration renderer registration " + type.getSerializeId());
        }
        RENDERERS.put(type, renderer);
    }

    public static void bindSimpleRenderer(CustomDecorationType<?, ?> type) {
        ResourceLocation texture = new ResourceLocation(type.getId().func_110624_b(), "textures/map/" + type.getId().func_110623_a() + ".png");
        MapDecorationClient.bindDecorationRenderer(type, new DecorationRenderer(texture));
    }

    public static <E extends CustomDecoration> DecorationRenderer<E> getRenderer(E decoration) {
        return RENDERERS.get(decoration.getType());
    }

    @Nullable
    public static <T extends CustomDecoration> boolean render(T decoration, MatrixStack matrixStack, IRenderTypeBuffer buffer, MapData mapData, boolean isOnFrame, int light, int index) {
        DecorationRenderer<T> renderer = MapDecorationClient.getRenderer(decoration);
        if (renderer != null) {
            return renderer.render(decoration, matrixStack, buffer, mapData, isOnFrame, light, index);
        }
        return false;
    }
}

