/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.world.data.map.sup;

import java.util.Objects;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.world.data.map.lib.CustomDecoration;
import net.mehvahdjukaar.supplementaries.world.data.map.lib.MapWorldMarker;
import net.mehvahdjukaar.supplementaries.world.data.map.sup.CMDreg;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;

public class BeaconMarker
extends MapWorldMarker<CustomDecoration> {
    @Nullable
    private final ITextComponent name;

    public BeaconMarker(BlockPos pos, @Nullable ITextComponent name) {
        super(CMDreg.BEACON_DECORATION_TYPE, pos);
        this.name = name;
    }

    @Override
    public CompoundNBT saveToNBT() {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.getPos()));
        if (this.name != null) {
            compoundnbt.func_74778_a("Name", ITextComponent.Serializer.func_150696_a((ITextComponent)this.name));
        }
        return compoundnbt;
    }

    public static BeaconMarker loadFromNBT(CompoundNBT compound) {
        BlockPos blockpos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("Pos"));
        IFormattableTextComponent itextcomponent = compound.func_74764_b("Name") ? ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("Name")) : null;
        return new BeaconMarker(blockpos, (ITextComponent)itextcomponent);
    }

    @Nullable
    public static BeaconMarker getFromWorld(IBlockReader world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof BeaconTileEntity) {
            BeaconTileEntity te = (BeaconTileEntity)tileentity;
            ITextComponent name = te.field_146008_p;
            return new BeaconMarker(pos, name);
        }
        return null;
    }

    @Override
    @Nullable
    public CustomDecoration doCreateDecoration(byte mapX, byte mapY, byte rot) {
        return new CustomDecoration(this.getType(), mapX, mapY, rot, this.name);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            BeaconMarker marker = (BeaconMarker)other;
            return Objects.equals(this.getPos(), marker.getPos()) && Objects.equals(this.name, marker.name);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getPos(), this.name);
    }

    @Override
    public boolean shouldUpdate(MapWorldMarker<?> other) {
        if (other instanceof BeaconMarker) {
            return !Objects.equals(this.name, ((BeaconMarker)other).name);
        }
        return false;
    }

    @Override
    public CustomDecoration updateDecoration(CustomDecoration old) {
        return new CustomDecoration(old.getType(), old.getX(), old.getY(), old.getRot(), this.name);
    }
}

