/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.world.data.map.sup;

import java.util.Objects;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.world.data.map.lib.CustomDecoration;
import net.mehvahdjukaar.supplementaries.world.data.map.lib.MapWorldMarker;
import net.mehvahdjukaar.supplementaries.world.data.map.sup.CMDreg;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.BedTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class BedMarker
extends MapWorldMarker<CustomDecoration> {
    private final DyeColor color;

    public BedMarker(BlockPos pos, DyeColor color) {
        super(CMDreg.BED_DECORATION_TYPE, pos);
        this.color = color;
    }

    @Override
    public CompoundNBT saveToNBT() {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.getPos()));
        compoundnbt.func_74778_a("Color", this.color.func_176762_d());
        return compoundnbt;
    }

    public static BedMarker loadFromNBT(CompoundNBT compound) {
        BlockPos blockpos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("Pos"));
        DyeColor dyecolor = DyeColor.func_204271_a((String)compound.func_74779_i("Color"), (DyeColor)DyeColor.WHITE);
        return new BedMarker(blockpos, dyecolor);
    }

    @Nullable
    public static BedMarker getFromWorld(IBlockReader world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof BedTileEntity) {
            DyeColor dyecolor = ((BedTileEntity)tileentity).func_193048_a();
            return new BedMarker(pos, dyecolor);
        }
        return null;
    }

    @Override
    @Nullable
    public CustomDecoration doCreateDecoration(byte mapX, byte mapY, byte rot) {
        return new CustomDecoration(this.getType(), mapX, mapY, rot, null);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            BedMarker marker = (BedMarker)other;
            return Objects.equals(this.getPos(), marker.getPos()) && this.color == marker.color;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getPos(), this.color);
    }
}

