/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.world.data.map.sup;

import java.util.Objects;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.tiles.FlagBlockTile;
import net.mehvahdjukaar.supplementaries.world.data.map.lib.MapWorldMarker;
import net.mehvahdjukaar.supplementaries.world.data.map.sup.CMDreg;
import net.mehvahdjukaar.supplementaries.world.data.map.sup.FlagDecoration;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;

public class FlagMarker
extends MapWorldMarker<FlagDecoration> {
    @Nullable
    private final ITextComponent name;
    private final DyeColor color;

    public FlagMarker(BlockPos pos, DyeColor color, @Nullable ITextComponent name) {
        super(CMDreg.FLAG_DECORATION_TYPE, pos);
        this.color = color;
        this.name = name;
    }

    @Override
    public CompoundNBT saveToNBT() {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.getPos()));
        compoundnbt.func_74778_a("Color", this.color.func_176762_d());
        if (this.name != null) {
            compoundnbt.func_74778_a("Name", ITextComponent.Serializer.func_150696_a((ITextComponent)this.name));
        }
        return compoundnbt;
    }

    public static FlagMarker loadFromNBT(CompoundNBT compound) {
        BlockPos blockpos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("Pos"));
        DyeColor dyecolor = DyeColor.func_204271_a((String)compound.func_74779_i("Color"), (DyeColor)DyeColor.WHITE);
        IFormattableTextComponent name = compound.func_74764_b("Name") ? ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("Name")) : null;
        return new FlagMarker(blockpos, dyecolor, (ITextComponent)name);
    }

    @Nullable
    public static FlagMarker getFromWorld(IBlockReader world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof FlagBlockTile) {
            FlagBlockTile flag = (FlagBlockTile)tileentity;
            DyeColor dyecolor = flag.getBaseColor(() -> ((FlagBlockTile)flag).func_195044_w());
            ITextComponent name = flag.func_145818_k_() ? flag.func_200201_e() : null;
            return new FlagMarker(pos, dyecolor, name);
        }
        return null;
    }

    @Override
    @Nullable
    public FlagDecoration doCreateDecoration(byte mapX, byte mapY, byte rot) {
        return new FlagDecoration(this.getType(), mapX, mapY, rot, this.name, this.color);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            FlagMarker marker = (FlagMarker)other;
            return Objects.equals(this.getPos(), marker.getPos()) && this.color == marker.color;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getPos(), this.color);
    }
}

