/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.world.structures;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.block.blocks.StructureTempBlock;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class RoadSignFeature
extends Feature<NoFeatureConfig> {
    private final BlockState cobble = Blocks.field_150347_e.func_176223_P();
    private final BlockState mossyCobble = Blocks.field_150341_Y.func_176223_P();
    private final BlockState fence = Blocks.field_180408_aP.func_176223_P();
    private final BlockState wall = Blocks.field_150463_bK.func_176223_P();
    private final BlockState mossyWall = Blocks.field_196723_eg.func_176223_P();

    public RoadSignFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    private static boolean canGoThrough(IWorld world, BlockPos pos) {
        if (!world.func_204610_c(pos).func_206888_e()) {
            return false;
        }
        return world.func_217375_a(pos, state -> {
            Material material = state.func_185904_a();
            return material.func_76222_j() || material == Material.field_151584_j || material == Material.field_151585_k;
        });
    }

    public static boolean isReplaceable(IWorld world, BlockPos pos) {
        return world.func_217375_a(pos, state -> {
            if (state.func_177230_c() instanceof StructureTempBlock) {
                return true;
            }
            Material material = state.func_185904_a();
            return material.func_76222_j() && material != Material.field_151584_j;
        });
    }

    public static boolean isNotSolid(IWorld world, BlockPos pos) {
        return !world.func_217375_a(pos, state -> state.func_215686_e((IBlockReader)world, pos));
    }

    public boolean place(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        pos = pos.func_177977_b();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                for (int k = 1; k <= 4; ++k) {
                    if ((Math.abs(i) == 2 || Math.abs(j) == 2) && k == 1) continue;
                    reader.func_180501_a(pos.func_177982_a(i, k, j), ((Block)Registry.STRUCTURE_TEMP.get()).func_176223_P(), 2);
                }
            }
        }
        float humidity = reader.func_226691_t_(pos).func_76727_i();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                reader.func_180501_a(pos.func_177982_a(i, -1, j), this.cobble, 2);
                BlockPos pathPos = pos.func_177982_a(i, 0, j);
                double dist = pos.func_218140_a((double)pathPos.func_177958_n(), (double)pathPos.func_177956_o(), (double)pathPos.func_177952_p(), false) / (double)5.2f;
                if ((double)rand.nextFloat() < dist - 0.15) continue;
                boolean m = (double)humidity * 0.75 > (double)rand.nextFloat();
                reader.func_180501_a(pathPos, m ? this.mossyCobble : this.cobble, 2);
            }
        }
        boolean m = (double)humidity * 0.75 > (double)rand.nextFloat();
        pos = pos.func_177984_a();
        reader.func_180501_a(pos, m ? this.mossyWall : this.wall, 2);
        pos = pos.func_177984_a();
        reader.func_180501_a(pos, this.fence, 2);
        pos = pos.func_177984_a();
        reader.func_180501_a(pos, this.fence, 2);
        reader.func_180501_a(pos.func_177984_a(), ((Block)Registry.BLOCK_GENERATOR.get()).func_176223_P(), 2);
        return true;
    }
}

