/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.world.structures;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class WaySignStructure
extends Structure<NoFeatureConfig> {
    public WaySignStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    private boolean isValidPos(ChunkGenerator gen, int x, int z, Set<Integer> heightMap) {
        int y = gen.func_222531_c(x, z, Heightmap.Type.WORLD_SURFACE_WG);
        IBlockReader reader = gen.func_230348_a_(x, z);
        try {
            if (!reader.func_204610_c(new BlockPos(x, y, z)).func_206888_e()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        heightMap.add(y);
        return true;
    }

    private boolean isNearOutpost(ChunkGenerator generator, long seed, SharedSeedRandom sharedSeedRandom, int chunkX, int chunkZ) {
        StructureSeparationSettings structureseparationsettings = generator.func_235957_b_().func_236197_a_(Structure.field_236366_b_);
        if (structureseparationsettings != null) {
            for (int i = chunkX - 8; i <= chunkX + 8; ++i) {
                for (int j = chunkZ - 8; j <= chunkZ + 8; ++j) {
                    ChunkPos chunkpos = Structure.field_236366_b_.func_236392_a_(structureseparationsettings, seed, sharedSeedRandom, i, j);
                    if (i != chunkpos.field_77276_a || j != chunkpos.field_77275_b) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        int x = (chunkX << 4) + 7;
        int z = (chunkZ << 4) + 7;
        int y = chunkGenerator.func_222531_c(x, z, Heightmap.Type.WORLD_SURFACE_WG);
        if (y > 105 || y < chunkGenerator.func_230356_f_() - 1) {
            return false;
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        set.add(y);
        if (!this.isValidPos(chunkGenerator, x + 2, z + 2, set)) {
            return false;
        }
        if (!this.isValidPos(chunkGenerator, x + 2, z - 2, set)) {
            return false;
        }
        if (!this.isValidPos(chunkGenerator, x - 2, z + 2, set)) {
            return false;
        }
        if (!this.isValidPos(chunkGenerator, x - 2, z - 2, set)) {
            return false;
        }
        if (set.last() - set.first() > 1) {
            return false;
        }
        return !this.isNearOutpost(chunkGenerator, seed, chunkRandom, chunkX, chunkZ);
    }

    public String func_143025_a() {
        return super.func_143025_a();
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            int x = (chunkX << 4) + 7;
            int z = (chunkZ << 4) + 7;
            int sum = 0;
            sum += chunkGenerator.func_222531_c(x, z, Heightmap.Type.WORLD_SURFACE_WG);
            sum += chunkGenerator.func_222531_c(x + 2, z + 2, Heightmap.Type.WORLD_SURFACE_WG);
            sum += chunkGenerator.func_222531_c(x + 2, z - 2, Heightmap.Type.WORLD_SURFACE_WG);
            sum += chunkGenerator.func_222531_c(x - 2, z + 2, Heightmap.Type.WORLD_SURFACE_WG);
            int y = Math.round((float)(sum += chunkGenerator.func_222531_c(x - 2, z - 2, Heightmap.Type.WORLD_SURFACE_WG)) / 5.0f);
            BlockPos blockpos = new BlockPos(x, y, z);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)((MutableRegistry)dynamicRegistryManager.func_230521_a_(Registry.field_243555_ax).get()).func_82594_a(new ResourceLocation("supplementaries", "way_sign/start_pool")), 5), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)templateManagerIn, (BlockPos)blockpos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)false);
            this.field_75075_a.forEach(piece -> piece.func_181138_a(0, 1, 0));
            this.func_202500_a();
            this.field_75074_b.field_78897_a -= 2;
            this.field_75074_b.field_78893_d += 3;
            this.field_75074_b.field_78896_c -= 2;
            this.field_75074_b.field_78892_f += 3;
            this.field_75074_b.field_78894_e += 4;
            this.field_75074_b.field_78895_b -= 0;
        }

        protected int func_212686_i() {
            return super.func_212686_i();
        }

        public MutableBoundingBox func_75071_a() {
            return super.func_75071_a();
        }

        public int func_227457_j_() {
            return super.func_227457_j_();
        }

        public BlockPos func_204294_a() {
            return new BlockPos((this.func_143019_e() << 4) + 7, 0, (this.func_143018_f() << 4) + 8);
        }
    }
}

