/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis_backpacks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class BackpackModHelper {
    public static boolean areWeOnClient(World world) {
        return world.field_72995_K;
    }

    public static boolean areWeOnServer(World world) {
        return !BackpackModHelper.areWeOnClient(world);
    }

    public static ResourceLocation prefix(String path) {
        return new ResourceLocation("omnis_backpacks", path);
    }

    public static <T> ArrayList<T> toArrayList(T ... items) {
        return new ArrayList<T>(Arrays.asList(items));
    }

    public static <T> ArrayList<T> toArrayList(Stream<T> items) {
        return items.collect(Collectors.toCollection(ArrayList::new));
    }

    public static String toTitleCase(String givenString, String regex) {
        String[] stringArray = givenString.split(regex);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(Character.toUpperCase(string.charAt(0))).append(string.substring(1)).append(regex);
        }
        return stringBuilder.toString().trim().replaceAll(regex, " ").substring(0, stringBuilder.length() - 1);
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Collection<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            return Collections.emptyList();
        }
        if (!src.removeAll(ret)) {
            return Collections.emptyList();
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Collection<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            return Collections.emptyList();
        }
        return ret;
    }
}

