/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis_backpacks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.sammy.omnis_backpacks.BackpackModHelper;
import com.sammy.omnis_backpacks.client.models.BackpackModel;
import com.sammy.omnis_backpacks.common.CurioProvider;
import com.sammy.omnis_backpacks.common.blocks.BackpackBlock;
import com.sammy.omnis_backpacks.common.blocks.BackpackTileEntity;
import com.sammy.omnis_backpacks.common.items.AbstractBackpackItem;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class HiddenHelper {
    public static boolean curiosEvent(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        PlayerEntity playerEntity = event.getPlayer();
        IItemHandlerModifiable handler = (IItemHandlerModifiable)CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)playerEntity).resolve().get();
        if (event.getHand().equals((Object)Hand.MAIN_HAND) && playerEntity.func_184586_b(Hand.MAIN_HAND).func_190926_b() && playerEntity.func_225608_bj_()) {
            TileEntity tileEntity = world.func_175625_s(event.getPos());
            Pair pair = HiddenHelper.equippedBackpackCurio((LivingEntity)playerEntity);
            ItemStack backpack = pair.stack;
            if (tileEntity instanceof BackpackTileEntity) {
                BackpackTileEntity backpackTileEntity = (BackpackTileEntity)tileEntity;
                if (backpack.func_190926_b()) {
                    world.func_184133_a(playerEntity, event.getPos(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    playerEntity.func_184609_a(Hand.MAIN_HAND);
                    if (BackpackModHelper.areWeOnServer(world)) {
                        handler.setStackInSlot(pair.index, backpackTileEntity.backpack);
                        world.func_217377_a(event.getPos(), true);
                    }
                    return true;
                }
            } else if (backpack.func_77973_b() instanceof AbstractBackpackItem) {
                AbstractBackpackItem backpackItem = (AbstractBackpackItem)backpack.func_77973_b();
                BlockPos pos = event.getPos().func_177972_a(event.getHitVec().func_216354_b());
                if (world.func_180495_p(pos).func_196958_f()) {
                    handler.setStackInSlot(pair.index, ItemStack.field_190927_a);
                    BlockState backpackState = (BlockState)backpackItem.backpackBlock.func_176223_P().func_206870_a((Property)BackpackBlock.field_185512_D, (Comparable)playerEntity.func_174811_aO());
                    world.func_175656_a(pos, backpackState);
                    tileEntity = world.func_175625_s(pos);
                    if (tileEntity instanceof BackpackTileEntity) {
                        BackpackTileEntity backpackTileEntity = (BackpackTileEntity)tileEntity;
                        backpackTileEntity.backpack = backpack.func_77946_l();
                        world.func_184138_a(pos, backpackState, backpackState, 3);
                    }
                    world.func_184133_a(playerEntity, event.getPos(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    playerEntity.func_184609_a(Hand.MAIN_HAND);
                    return true;
                }
            }
        }
        return false;
    }

    public static void addCuriosSlot() {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    public static ICapabilityProvider curiosBackpackProvider(final ItemStack stack) {
        return CurioProvider.createProvider(new ICurio(){
            public final ResourceLocation texture = BackpackModHelper.prefix("textures/block/backpack_base.png");
            public BackpackModel model;

            public void playRightClickEquipSound(LivingEntity livingEntity) {
                livingEntity.field_70170_p.func_184133_a(null, livingEntity.func_233580_cy_(), SoundEvents.field_187728_s, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }

            public boolean canEquip(String identifier, LivingEntity livingEntity) {
                if (livingEntity instanceof PlayerEntity && ((PlayerEntity)livingEntity).field_71070_bA != null) {
                    return true;
                }
                return livingEntity.func_225608_bj_();
            }

            public boolean canRender(String identifier, int index, LivingEntity livingEntity) {
                return true;
            }

            public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                matrixStack.func_227860_a_();
                if (this.model == null) {
                    this.model = new BackpackModel();
                }
                this.model.func_225597_a_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                this.model.func_212843_a_(livingEntity, limbSwing, limbSwingAmount, partialTicks);
                int i = ((IDyeableArmorItem)stack.func_77973_b()).func_200886_f(stack);
                float r = (float)(i >> 16 & 0xFF) / 255.0f;
                float g = (float)(i >> 8 & 0xFF) / 255.0f;
                float b = (float)(i & 0xFF) / 255.0f;
                IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)this.model.func_228282_a_(this.texture), (boolean)false, (boolean)false);
                this.model.func_225598_a_(matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, r, g, b, 1.0f);
                ResourceLocation overlay = BackpackModHelper.prefix(((AbstractBackpackItem)stack.func_77973_b()).overlayTexture());
                vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)this.model.func_228282_a_(overlay), (boolean)false, (boolean)false);
                this.model.func_225598_a_(matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                matrixStack.func_227865_b_();
            }

            public boolean canRightClickEquip() {
                return true;
            }
        });
    }

    public static Pair equippedBackpackCurio(LivingEntity entity) {
        IItemHandlerModifiable handler = (IItemHandlerModifiable)CuriosApi.getCuriosHelper().getEquippedCurios(entity).resolve().get();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!(handler.getStackInSlot(i).func_77973_b() instanceof AbstractBackpackItem)) continue;
            return new Pair(handler.getStackInSlot(i), i);
        }
        return new Pair(ItemStack.field_190927_a, 0);
    }

    public static class Pair {
        public ItemStack stack;
        public int index;

        public Pair(ItemStack stack, int index) {
            this.stack = stack;
            this.index = index;
        }
    }
}

