/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis_backpacks.common.blocks;

import com.sammy.omnis_backpacks.BackpackModHelper;
import com.sammy.omnis_backpacks.common.blocks.BackpackTileEntity;
import com.sammy.omnis_backpacks.common.items.AbstractBackpackItem;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BackpackBlock
extends HorizontalBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final VoxelShape NORTH = Stream.of(Block.func_208617_a((double)5.0, (double)0.0, (double)10.0, (double)11.0, (double)7.0, (double)12.0), Block.func_208617_a((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)12.0, (double)10.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final VoxelShape EAST = Stream.of(Block.func_208617_a((double)4.0, (double)0.0, (double)5.0, (double)6.0, (double)7.0, (double)11.0), Block.func_208617_a((double)6.0, (double)0.0, (double)3.0, (double)12.0, (double)12.0, (double)13.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final VoxelShape SOUTH = Stream.of(Block.func_208617_a((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)7.0, (double)6.0), Block.func_208617_a((double)3.0, (double)0.0, (double)6.0, (double)13.0, (double)12.0, (double)12.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final VoxelShape WEST = Stream.of(Block.func_208617_a((double)10.0, (double)0.0, (double)5.0, (double)12.0, (double)7.0, (double)11.0), Block.func_208617_a((double)4.0, (double)0.0, (double)3.0, (double)10.0, (double)12.0, (double)13.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public BackpackBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)field_185512_D)) {
            case NORTH: {
                return NORTH;
            }
            case EAST: {
                return EAST;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
        }
        return super.func_220053_a(state, worldIn, pos, context);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof BackpackTileEntity) {
            BackpackTileEntity backpackTileEntity = (BackpackTileEntity)tileEntity;
            if (backpackTileEntity.backpack != null) {
                world.func_217376_c((Entity)new ItemEntity(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), backpackTileEntity.backpack));
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, WATERLOGGED});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BackpackTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (handIn.equals((Object)Hand.OFF_HAND) || BackpackModHelper.areWeOnClient(worldIn)) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof BackpackTileEntity) {
            BackpackTileEntity backpackTileEntity = (BackpackTileEntity)tileEntity;
            if (backpackTileEntity.backpack != null) {
                AbstractBackpackItem backpackItem = (AbstractBackpackItem)backpackTileEntity.backpack.func_77973_b();
                backpackItem.openContainer(worldIn, player, backpackTileEntity.backpack);
                worldIn.func_184133_a(player, pos, SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.0f, 1.0f);
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof BackpackTileEntity) {
            BackpackTileEntity backpackTileEntity = (BackpackTileEntity)tileEntity;
            if (backpackTileEntity.backpack != null) {
                return backpackTileEntity.backpack;
            }
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (worldIn.func_175625_s(pos) instanceof BackpackTileEntity) {
            BackpackTileEntity tileEntity = (BackpackTileEntity)worldIn.func_175625_s(pos);
            tileEntity.backpack = stack.func_77946_l();
            worldIn.func_184138_a(pos, state, state, 3);
        }
    }
}

