/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis_backpacks.common.items;

import com.sammy.omnis_backpacks.HiddenHelper;
import com.sammy.omnis_backpacks.client.models.BackpackModel;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.LazyValue;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class AbstractBackpackItem
extends ArmorItem
implements IDyeableArmorItem {
    public final Block backpackBlock;
    private LazyValue<Object> model;

    public AbstractBackpackItem(Block backpackBlock, Item.Properties builder) {
        super((IArmorMaterial)ArmorMaterial.LEATHER, EquipmentSlotType.CHEST, builder);
        this.backpackBlock = backpackBlock;
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.model = (LazyValue)DistExecutor.runForDist(() -> () -> new LazyValue(BackpackModel::new), () -> () -> null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A original) {
        return (A)((BipedModel)this.model.func_179281_c());
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if (type != null) {
            return "omnis_backpacks:" + this.overlayTexture();
        }
        return "omnis_backpacks:textures/block/backpack_base.png";
    }

    public String overlayTexture() {
        return null;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (!ModList.get().isLoaded("curios")) {
            return null;
        }
        return HiddenHelper.curiosBackpackProvider(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (playerIn.func_225608_bj_()) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        ItemStack backpack = playerIn.func_184586_b(handIn);
        this.openContainer(worldIn, playerIn, backpack);
        return ActionResult.func_226248_a_((Object)backpack);
    }

    public void openContainer(World world, PlayerEntity player, ItemStack backpack) {
    }
}

