/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis_backpacks.data;

import com.sammy.omnis_backpacks.BackpackModHelper;
import com.sammy.omnis_backpacks.common.blocks.BackpackBlock;
import com.sammy.omnis_backpacks.init.Registries;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "omnis_backpacks", exFileHelper);
    }

    @Nonnull
    public String func_200397_b() {
        return "Block States";
    }

    protected void registerStatesAndModels() {
        HashSet blocks = new HashSet(Registries.BLOCKS.getEntries());
        BackpackModHelper.takeAll(blocks, b -> b.get() instanceof BackpackBlock).forEach(this::backpackBlock);
        BackpackModHelper.takeAll(blocks, b -> b.get() instanceof GrassBlock).forEach(this::grassBlock);
        BackpackModHelper.takeAll(blocks, b -> b.get() instanceof StairsBlock).forEach(this::stairsBlock);
        BackpackModHelper.takeAll(blocks, b -> b.get() instanceof RotatedPillarBlock).forEach(this::logBlock);
        BackpackModHelper.takeAll(blocks, b -> b.get() instanceof WallBlock).forEach(this::wallBlock);
        BackpackModHelper.takeAll(blocks, b -> b.get() instanceof FenceBlock).forEach(this::fenceBlock);
        BackpackModHelper.takeAll(blocks, b -> b.get() instanceof FenceGateBlock).forEach(this::fenceGateBlock);
        BackpackModHelper.takeAll(blocks, b -> b.get() instanceof DoorBlock).forEach(this::doorBlock);
        BackpackModHelper.takeAll(blocks, b -> b.get() instanceof TrapDoorBlock).forEach(this::trapdoorBlock);
        BackpackModHelper.takeAll(blocks, b -> b.get() instanceof PressurePlateBlock).forEach(this::pressurePlateBlock);
        BackpackModHelper.takeAll(blocks, b -> b.get() instanceof AbstractButtonBlock).forEach(this::buttonBlock);
        BackpackModHelper.takeAll(blocks, b -> b.get() instanceof DoublePlantBlock).forEach(this::tallPlantBlock);
        BackpackModHelper.takeAll(blocks, b -> b.get() instanceof BushBlock).forEach(this::plantBlock);
        BackpackModHelper.takeAll(blocks, b -> b.get() instanceof LanternBlock).forEach(this::lanternBlock);
        BackpackModHelper.takeAll(blocks, b -> b.get() instanceof WallTorchBlock).forEach(this::wallTorchBlock);
        BackpackModHelper.takeAll(blocks, b -> b.get() instanceof TorchBlock).forEach(this::torchBlock);
        Collection<RegistryObject> slabs = BackpackModHelper.takeAll(blocks, b -> b.get() instanceof SlabBlock);
        blocks.forEach(this::basicBlock);
        slabs.forEach(this::slabBlock);
    }

    public void backpackBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder backpack = ((BlockModelBuilder)this.models().withExistingParent(name, BackpackModHelper.prefix("block/backpack"))).texture("nocolor", "block/" + name);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)HorizontalBlock.field_185512_D, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)backpack).addModel()).partialState().with((Property)HorizontalBlock.field_185512_D, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)backpack).rotationY(270).addModel()).partialState().with((Property)HorizontalBlock.field_185512_D, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)backpack).rotationY(180).addModel()).partialState().with((Property)HorizontalBlock.field_185512_D, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)backpack).rotationY(90).addModel();
    }

    public void basicBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get());
    }

    public void emptyBlock(RegistryObject<Block> blockRegistryObject) {
        ModelFile.ExistingModelFile empty = this.models().getExistingFile(new ResourceLocation("block/air"));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> ModBlockStateProvider.lambda$emptyBlock$17((ModelFile)empty, arg_0));
    }

    public void trapdoorBlock(RegistryObject<Block> blockRegistryObject) {
        this.trapdoorBlock((TrapDoorBlock)blockRegistryObject.get(), this.blockTexture((Block)blockRegistryObject.get()), true);
    }

    public void torchBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder torch = this.models().torchWall(((Block)blockRegistryObject.get()).getRegistryName().func_110623_a(), BackpackModHelper.prefix("block/" + name));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> ModBlockStateProvider.lambda$torchBlock$18((ModelFile)torch, arg_0));
    }

    public void wallTorchBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder torch = this.models().torchWall(((Block)blockRegistryObject.get()).getRegistryName().func_110623_a(), BackpackModHelper.prefix("block/" + name.substring(5)));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)torch).rotationY(270).addModel()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)torch).rotationY(180).addModel()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)torch).rotationY(90).addModel()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)torch).addModel();
    }

    public void grassBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder file = this.models().cubeBottomTop(name, BackpackModHelper.prefix("block/" + name + "_side"), new ResourceLocation("block/dirt"), BackpackModHelper.prefix("block/" + name + "_top"));
        this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().modelForState().modelFile((ModelFile)file).nextModel().modelFile((ModelFile)file).rotationY(90).nextModel().modelFile((ModelFile)file).rotationY(180).nextModel().modelFile((ModelFile)file).rotationY(270).addModel();
    }

    public void doorBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        this.doorBlock((DoorBlock)blockRegistryObject.get(), BackpackModHelper.prefix("block/" + name + "_bottom"), BackpackModHelper.prefix("block/" + name + "_top"));
    }

    public void fenceGateBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 11);
        this.fenceGateBlock((FenceGateBlock)blockRegistryObject.get(), BackpackModHelper.prefix("block/" + baseName));
    }

    public void fenceBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 6);
        this.fenceBlock((FenceBlock)blockRegistryObject.get(), BackpackModHelper.prefix("block/" + baseName));
    }

    public void wallBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 5);
        this.wallBlock((WallBlock)blockRegistryObject.get(), BackpackModHelper.prefix("block/" + baseName));
    }

    public void stairsBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 7);
        this.stairsBlock((StairsBlock)blockRegistryObject.get(), BackpackModHelper.prefix("block/" + baseName));
    }

    public void pressurePlateBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 15);
        ModelBuilder pressurePlateDown = ((BlockModelBuilder)this.models().withExistingParent(name + "_down", new ResourceLocation("block/pressure_plate_down"))).texture("texture", BackpackModHelper.prefix("block/" + baseName));
        ModelBuilder pressurePlateUp = ((BlockModelBuilder)this.models().withExistingParent(name + "_up", new ResourceLocation("block/pressure_plate_up"))).texture("texture", BackpackModHelper.prefix("block/" + baseName));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)PressurePlateBlock.field_176580_a, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)pressurePlateDown).addModel()).partialState().with((Property)PressurePlateBlock.field_176580_a, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)pressurePlateUp).addModel();
    }

    public void lanternBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder lantern = ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/template_lantern"))).texture("lantern", BackpackModHelper.prefix("block/" + name));
        ModelBuilder hangingLantern = ((BlockModelBuilder)this.models().withExistingParent(name + "_hanging", new ResourceLocation("block/template_hanging_lantern"))).texture("lantern", BackpackModHelper.prefix("block/" + name));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)hangingLantern).addModel()).partialState().with((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)lantern).addModel();
    }

    public void buttonBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 7);
        ModelBuilder buttom = ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/button"))).texture("texture", BackpackModHelper.prefix("block/" + baseName));
        ModelBuilder buttonPressed = ((BlockModelBuilder)this.models().withExistingParent(name + "_pressed", new ResourceLocation("block/button_pressed"))).texture("texture", BackpackModHelper.prefix("block/" + baseName));
        Function<BlockState, ModelFile> modelFunc = arg_0 -> ModBlockStateProvider.lambda$buttonBlock$19((ModelFile)buttom, arg_0);
        Function<BlockState, ModelFile> pressedModelFunc = arg_0 -> ModBlockStateProvider.lambda$buttonBlock$20((ModelFile)buttonPressed, arg_0);
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(s -> ConfiguredModel.builder().modelFile((Boolean)s.func_177229_b((Property)BlockStateProperties.field_208194_u) != false ? (ModelFile)pressedModelFunc.apply((BlockState)s) : (ModelFile)modelFunc.apply((BlockState)s)).uvLock(((AttachFace)s.func_177229_b((Property)BlockStateProperties.field_208158_K)).equals((Object)AttachFace.WALL)).rotationX(((AttachFace)s.func_177229_b((Property)BlockStateProperties.field_208158_K)).ordinal() * 90).rotationY(((int)((Direction)s.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + 180 + (s.func_177229_b((Property)BlockStateProperties.field_208158_K) == AttachFace.CEILING ? 180 : 0)) % 360).build());
        ((BlockModelBuilder)this.models().withExistingParent(name + "_inventory", new ResourceLocation("block/button_inventory"))).texture("texture", BackpackModHelper.prefix("block/" + baseName));
    }

    public void tallPlantBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder bottom = ((BlockModelBuilder)this.models().withExistingParent(name + "_bottom", new ResourceLocation("block/cross"))).texture("cross", BackpackModHelper.prefix("block/" + name + "_bottom"));
        ModelBuilder top = ((BlockModelBuilder)this.models().withExistingParent(name + "_top", new ResourceLocation("block/cross"))).texture("cross", BackpackModHelper.prefix("block/" + name + "_top"));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER).modelForState().modelFile((ModelFile)bottom).addModel()).partialState().with((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER).modelForState().modelFile((ModelFile)top).addModel();
    }

    public void plantBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder cross = ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/cross"))).texture("cross", BackpackModHelper.prefix("block/" + name));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> ModBlockStateProvider.lambda$plantBlock$22((ModelFile)cross, arg_0));
    }

    public void slabBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 5);
        this.slabBlock((SlabBlock)blockRegistryObject.get(), BackpackModHelper.prefix(baseName), BackpackModHelper.prefix("block/" + baseName));
    }

    public void logBlock(RegistryObject<Block> blockRegistryObject) {
        this.logBlock((RotatedPillarBlock)blockRegistryObject.get());
    }

    public void woodBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name + "_log";
        this.axisBlock((RotatedPillarBlock)blockRegistryObject.get(), BackpackModHelper.prefix("block/" + baseName), BackpackModHelper.prefix("block/" + baseName));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$plantBlock$22(ModelFile cross, BlockState s) {
        return ConfiguredModel.builder().modelFile(cross).build();
    }

    private static /* synthetic */ ModelFile lambda$buttonBlock$20(ModelFile buttonPressed, BlockState $) {
        return buttonPressed;
    }

    private static /* synthetic */ ModelFile lambda$buttonBlock$19(ModelFile buttom, BlockState $) {
        return buttom;
    }

    private static /* synthetic */ ConfiguredModel[] lambda$torchBlock$18(ModelFile torch, BlockState s) {
        return ConfiguredModel.builder().modelFile(torch).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$emptyBlock$17(ModelFile empty, BlockState s) {
        return ConfiguredModel.builder().modelFile(empty).build();
    }
}

