/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis_backpacks.data;

import com.sammy.omnis_backpacks.BackpackModHelper;
import com.sammy.omnis_backpacks.init.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    private static final ResourceLocation GENERATED = new ResourceLocation("item/generated");
    private static final ResourceLocation HANDHELD = new ResourceLocation("item/handheld");

    public ModItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "omnis_backpacks", existingFileHelper);
    }

    protected void registerModels() {
        this.backpackItem(Registries.BACKPACK, "backpack_gold_overlay");
        this.backpackItem(Registries.NETHERITE_BACKPACK, "backpack_netherite_overlay");
        this.backpackItem(Registries.ENDER_BACKPACK, "backpack_ender_overlay");
    }

    private void handheldItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.withExistingParent(name, HANDHELD)).texture("layer0", BackpackModHelper.prefix("item/" + name));
    }

    private void backpackItem(RegistryObject<Item> i, String overlay) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", BackpackModHelper.prefix("item/backpack_base"))).texture("layer1", BackpackModHelper.prefix("item/" + overlay));
    }

    private void generatedItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", BackpackModHelper.prefix("item/" + name));
    }

    private void blockGeneratedItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", BackpackModHelper.prefix("block/" + name));
    }

    private void blockItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(BackpackModHelper.prefix("block/" + name)));
    }

    private void trapdoorBlockItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(BackpackModHelper.prefix("block/" + name + "_bottom")));
    }

    private void fenceBlockItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 6);
        this.fenceInventory(name, BackpackModHelper.prefix("block/" + baseName));
    }

    private void wallBlockItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 5);
        this.wallInventory(name, BackpackModHelper.prefix("block/" + baseName));
    }

    private void pressurePlateBlockItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(BackpackModHelper.prefix("block/" + name + "_up")));
    }

    private void buttonBlockItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(BackpackModHelper.prefix("block/" + name + "_inventory")));
    }

    public String func_200397_b() {
        return "Item Models";
    }
}

