/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis_backpacks.init;

import com.sammy.omnis_backpacks.common.blocks.BackpackTileEntity;
import com.sammy.omnis_backpacks.container.ender.EnderBackpackScreen;
import com.sammy.omnis_backpacks.container.gold.GoldenBackpackScreen;
import com.sammy.omnis_backpacks.container.netherite.NetheriteBackpackScreen;
import com.sammy.omnis_backpacks.init.Registries;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="omnis_backpacks", value={Dist.CLIENT})
public class ClientRegistries {
    public static final KeyBinding BACKPACK_KEYBINDING = new KeyBinding("key.omnis_backpack", 66, "key.categories.misc");

    @SubscribeEvent
    public static void registerKeybind(FMLClientSetupEvent event) {
        ClientRegistry.registerKeyBinding((KeyBinding)BACKPACK_KEYBINDING);
    }

    @SubscribeEvent
    public static void registerScreenFactory(FMLClientSetupEvent event) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ScreenManager.func_216911_a((ContainerType)((ContainerType)Registries.GOLDEN_BACKPACK_CONTAINER.get()), GoldenBackpackScreen::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)Registries.ENDER_BACKPACK_CONTAINER.get()), EnderBackpackScreen::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)Registries.NETHERITE_BACKPACK_CONTAINER.get()), NetheriteBackpackScreen::new);
        });
        ClientRegistries.setCutout(Registries.GOLDEN_BACKPACK_BLOCK);
        ClientRegistries.setCutout(Registries.NETHERITE_BACKPACK_BLOCK);
        ClientRegistries.setCutout(Registries.ENDER_BACKPACK_BLOCK);
    }

    @SubscribeEvent
    public static void setBlockColors(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        blockColors.func_186722_a((state, reader, pos, color) -> {
            TileEntity tileEntity = reader.func_175625_s(pos);
            if (tileEntity instanceof BackpackTileEntity) {
                ItemStack stack;
                BackpackTileEntity backpackTileEntity = (BackpackTileEntity)tileEntity;
                if (backpackTileEntity.backpack != null && (stack = backpackTileEntity.backpack).func_77973_b() instanceof IDyeableArmorItem) {
                    return color > 0 ? -1 : ((IDyeableArmorItem)stack.func_77973_b()).func_200886_f(stack);
                }
            }
            return -1;
        }, new Block[]{(Block)Registries.GOLDEN_BACKPACK_BLOCK.get(), (Block)Registries.ENDER_BACKPACK_BLOCK.get(), (Block)Registries.NETHERITE_BACKPACK_BLOCK.get()});
    }

    @SubscribeEvent
    public static void setItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        itemColors.func_199877_a((stack, color) -> color > 0 ? -1 : ((IDyeableArmorItem)stack.func_77973_b()).func_200886_f(stack), new IItemProvider[]{(IItemProvider)Registries.BACKPACK.get(), (IItemProvider)Registries.ENDER_BACKPACK.get(), (IItemProvider)Registries.NETHERITE_BACKPACK.get()});
    }

    public static void setCutout(RegistryObject<Block> b) {
        RenderTypeLookup.setRenderLayer((Block)((Block)b.get()), (RenderType)RenderType.func_228643_e_());
    }
}

