/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis_backpacks.systems.inventory;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.items.ItemStackHandler;

public class SimpleInventory
extends ItemStackHandler {
    public int slotCount;
    public int slotSize;
    public Predicate<ItemStack> inputPredicate;
    public Predicate<ItemStack> outputPredicate;

    public SimpleInventory(int slotCount, int slotSize, Predicate<ItemStack> inputPredicate, Predicate<ItemStack> outputPredicate) {
        this(slotCount, slotSize, inputPredicate);
        this.outputPredicate = outputPredicate;
    }

    public SimpleInventory(int slotCount, int slotSize, Predicate<ItemStack> inputPredicate) {
        this(slotCount, slotSize);
        this.inputPredicate = inputPredicate;
    }

    public SimpleInventory(int slotCount, int slotSize) {
        super(slotCount);
        this.slotCount = slotCount;
        this.slotSize = slotSize;
    }

    public int firstEmptyItem() {
        for (int i = 0; i < this.slotCount; ++i) {
            if (!this.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public int nonEmptyItems() {
        ItemStack item;
        int itemCount = 0;
        for (int i = 0; i < this.slotCount && !(item = this.getStackInSlot(i)).func_190926_b(); ++i) {
            ++itemCount;
        }
        return itemCount;
    }

    public void clearItems() {
        for (int i = 0; i < this.slotCount; ++i) {
            this.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public ArrayList<Item> items() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < this.slotCount; ++i) {
            items.add(this.getStackInSlot(i).func_77973_b());
        }
        return items;
    }

    public ArrayList<ItemStack> stacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.slotCount; ++i) {
            stacks.add(this.getStackInSlot(i));
        }
        return stacks;
    }

    public ArrayList<ItemStack> nonEmptyStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.slotCount; ++i) {
            if (this.getStackInSlot(i).func_190926_b()) continue;
            stacks.add(this.getStackInSlot(i));
        }
        return stacks;
    }

    public int getSlots() {
        return this.slotCount;
    }

    public int getSlotLimit(int slot) {
        return this.slotSize;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (this.inputPredicate != null && !this.inputPredicate.test(stack)) {
            return false;
        }
        return super.isItemValid(slot, stack);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.outputPredicate != null && !this.outputPredicate.test(super.extractItem(slot, amount, true))) {
            return ItemStack.field_190927_a;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public void readData(CompoundNBT compound) {
        this.readData(compound, "inventory");
    }

    public CompoundNBT writeData(CompoundNBT compound) {
        this.writeData(compound, "inventory");
        return compound;
    }

    public void readData(CompoundNBT compound, String name) {
        this.deserializeNBT((CompoundNBT)Objects.requireNonNull(compound.func_74781_a(name)));
    }

    public CompoundNBT writeData(CompoundNBT compound, String name) {
        compound.func_218657_a(name, (INBT)this.serializeNBT());
        return compound;
    }
}

