/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.client.model;

import io.github.how_bout_no.outvoted.entity.HungerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class HungerModel
extends AnimatedGeoModel<HungerEntity> {
    public ResourceLocation getAnimationFileLocation(HungerEntity entity) {
        return new ResourceLocation("outvoted", "animations/hunger.animation.json");
    }

    public ResourceLocation getModelLocation(HungerEntity entity) {
        return new ResourceLocation("outvoted", "geo/hunger.geo.json");
    }

    public ResourceLocation getTextureLocation(HungerEntity entity) {
        return new ResourceLocation("outvoted", "textures/entity/hunger.png");
    }

    public void setLivingAnimations(HungerEntity entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone head = this.getBone("head");
        IBone legBR = this.getBone("LegBR");
        IBone legBL = this.getBone("LegBL");
        IBone legFR = this.getBone("LegFR");
        IBone legFL = this.getBone("LegFL");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        head.setRotationX(extraData.headPitch * 0.009519978f);
        head.setRotationY(extraData.netHeadYaw * 0.009519978f);
        float limbSwing = entity.field_184619_aG;
        float limbSwingAmount = entity.field_70721_aZ;
        legBR.setRotationX(MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount);
        legBL.setRotationX(MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount);
        legFR.setRotationX(MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount);
        legFL.setRotationX(MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount);
    }
}

