/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.client.model;

import io.github.how_bout_no.outvoted.entity.KrakenEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class KrakenModel
extends AnimatedGeoModel<KrakenEntity> {
    public ResourceLocation getAnimationFileLocation(KrakenEntity entity) {
        return new ResourceLocation("outvoted", "animations/kraken.animation.json");
    }

    public ResourceLocation getModelLocation(KrakenEntity entity) {
        return new ResourceLocation("outvoted", "geo/kraken.geo.json");
    }

    public ResourceLocation getTextureLocation(KrakenEntity entity) {
        return new ResourceLocation("outvoted", "textures/entity/kraken.png");
    }

    public void setLivingAnimations(KrakenEntity entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone mob = this.getBone("mob");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        mob.setRotationX(extraData.headPitch * ((float)Math.PI / 180) - 1.7f);
        mob.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
    }
}

