/*
 * Decompiled with CFR 0.152.
 */
package io.github.how_bout_no.outvoted.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

class ShapedBuilder
extends ShapedRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    private String group;

    public ShapedBuilder(IItemProvider resultIn, int countIn) {
        super(resultIn, countIn);
        this.result = resultIn.func_199767_j();
        this.count = countIn;
    }

    public static ShapedRecipeBuilder shapedRecipe(IItemProvider resultIn) {
        return ShapedBuilder.shapedRecipe(resultIn, 1);
    }

    public static ShapedRecipeBuilder shapedRecipe(IItemProvider resultIn, int countIn) {
        return new ShapedBuilder(resultIn, countIn);
    }

    public ShapedRecipeBuilder func_200469_a(Character symbol, ITag<Item> tagIn) {
        return this.func_200471_a(symbol, Ingredient.func_199805_a(tagIn));
    }

    public ShapedRecipeBuilder func_200462_a(Character symbol, IItemProvider itemIn) {
        return this.func_200471_a(symbol, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
    }

    public ShapedRecipeBuilder func_200471_a(Character symbol, Ingredient ingredientIn) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, ingredientIn);
        return this;
    }

    public ShapedRecipeBuilder func_200472_a(String patternIn) {
        if (!this.pattern.isEmpty() && patternIn.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(patternIn);
        return this;
    }

    public ShapedRecipeBuilder func_200465_a(String name, ICriterionInstance criterionIn) {
        this.advancementBuilder.func_200275_a(name, criterionIn);
        return this;
    }

    public ShapedRecipeBuilder func_200473_b(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public void func_200464_a(Consumer<IFinishedRecipe> consumerIn) {
        this.func_200467_a(consumerIn, Registry.field_212630_s.func_177774_c((Object)this.result));
    }

    public void func_200466_a(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = Registry.field_212630_s.func_177774_c((Object)this.result);
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shaped Recipe " + save + " should remove its 'save' argument");
        }
        this.func_200467_a(consumerIn, new ResourceLocation(save));
    }

    public void func_200467_a(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumerIn.accept((IFinishedRecipe)new ShapedRecipeBuilder.Result((ShapedRecipeBuilder)this, id, this.result, this.count, this.group == null ? "" : this.group, this.pattern, this.key, this.advancementBuilder, new ResourceLocation(id.func_110624_b(), "recipes/misc/" + id.func_110623_a())));
    }
}

