/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.towers_of_the_wild.config;

import com._idrae.towers_of_the_wild.TowersOfTheWild;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="towers_of_the_wild", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TowersOfTheWildConfig {
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static int rarity;
    public static int derelictRarity;
    public static boolean spawnOceanTowers;
    public static int oceanRarity;
    public static List<String> allModBiomesBlackList;
    public static List<String> biomeBlackList;
    public static boolean waystonesCompat;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            TowersOfTheWildConfig.bakeConfig();
            TowersOfTheWild.LOGGER.info("Config set");
        }
    }

    public static void bakeConfig() {
        rarity = (Integer)TowersOfTheWildConfig.COMMON.towerRarity.get();
        derelictRarity = (Integer)TowersOfTheWildConfig.COMMON.derelictTowerRarity.get();
        spawnOceanTowers = (Boolean)TowersOfTheWildConfig.COMMON.spawnOceanTowers.get();
        oceanRarity = (Integer)TowersOfTheWildConfig.COMMON.oceanTowerRarity.get();
        allModBiomesBlackList = (List)TowersOfTheWildConfig.COMMON.allModBiomesBlackList.get();
        biomeBlackList = (List)TowersOfTheWildConfig.COMMON.biomeBlackList.get();
        waystonesCompat = (Boolean)TowersOfTheWildConfig.COMMON.waystonesCompat.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.IntValue towerRarity;
        public final ForgeConfigSpec.IntValue derelictTowerRarity;
        public final ForgeConfigSpec.BooleanValue spawnOceanTowers;
        public final ForgeConfigSpec.IntValue oceanTowerRarity;
        public final ForgeConfigSpec.ConfigValue<List<String>> allModBiomesBlackList;
        public final ForgeConfigSpec.ConfigValue<List<String>> biomeBlackList;
        public final ForgeConfigSpec.BooleanValue waystonesCompat;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("towers");
            this.towerRarity = builder.comment("How rarely the towers will spawn (low: common, high: rare). Default: 20").defineInRange("towerRarity", 20, 3, 200);
            this.derelictTowerRarity = builder.comment("How rarely the derelict towers will spawn (low: common, high: rare). Default: 72").defineInRange("derelictTowerRarity", 72, 3, 200);
            this.spawnOceanTowers = builder.comment("Make towers spawn in the ocean. Default: true").define("spawnOceanTowers", true);
            this.oceanTowerRarity = builder.comment("How rarely the ocean towers will spawn (low: common, high: rare). Default: 32").defineInRange("oceanTowerRarity", 32, 3, 200);
            this.allModBiomesBlackList = builder.comment("A list of mod ids. In each and every biome added by those mods, the towers will not spawn. Default : The Midnight.").define("allModBiomesBlackList", (Object)Lists.newArrayList((Object[])new String[]{"midnight", "the_bumblezone"}));
            this.biomeBlackList = builder.comment("A list of biomes where the towers will not spawn. Default: Rivers, Beaches").define("biomeBlackList", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:river", "minecraft:frozen_river", "minecraft:beach", "minecraft:stone_shore", "minecraft:snowy_beach", "biomesoplenty:gravel_beach", "biomesoplenty:white_beach"}));
            this.waystonesCompat = builder.comment("If the Waytones mod is installed and this is set to true, towers will spawn with a waystone at the top. If the Waystone mod is not installed, this will have no effect. Default: true").define("waystonesCompat", true);
            builder.pop();
        }
    }
}

