/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.towers_of_the_wild.structures;

import com._idrae.towers_of_the_wild.config.TowersOfTheWildConfig;
import com._idrae.towers_of_the_wild.structures.AbstractTowerStructure;
import com._idrae.towers_of_the_wild.structures.pieces.OceanWarmTowerPools;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class OceanWarmTowerStructure
extends AbstractTowerStructure {
    public OceanWarmTowerStructure(Codec<VillageConfig> p_i231997_1_) {
        super(p_i231997_1_);
    }

    @Override
    public int getSeedModifier() {
        return 1689782;
    }

    @Override
    public int getSize() {
        return 7;
    }

    @Override
    public int getDistance() {
        return TowersOfTheWildConfig.oceanRarity;
    }

    @Override
    public int getSeparation() {
        return TowersOfTheWildConfig.oceanRarity / 3;
    }

    @Override
    protected boolean alreadyIsTower(ChunkGenerator generator, AbstractTowerStructure structure, long seed, SharedSeedRandom rand, int chunkX, int chunkZ) {
        return false;
    }

    @Override
    protected boolean func_230363_a_(ChunkGenerator generator, BiomeProvider biomeProvider, long seed, SharedSeedRandom rand, int chunkX, int chunkZ, Biome biome, ChunkPos pos, VillageConfig config) {
        if (this.isTerrainFlat(generator, chunkX, chunkZ) && !this.alreadyIsTower(generator, this, seed, rand, chunkX, chunkZ)) {
            int xStart = chunkX * 16;
            int zStart = chunkZ * 16;
            int startHeight = generator.func_222529_a(xStart, zStart, Heightmap.Type.OCEAN_FLOOR_WG);
            return startHeight <= 38;
        }
        return false;
    }

    @Override
    public Structure.IStartFactory<VillageConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends MarginedStructureStart<VillageConfig> {
        public Start(Structure<VillageConfig> structure, int p_i225876_2_, int p_i225876_3_, MutableBoundingBox boundingBox, int p_i225876_5_, long p_i225876_6_) {
            super(structure, p_i225876_2_, p_i225876_3_, boundingBox, p_i225876_5_, p_i225876_6_);
        }

        public void func_230364_a_(DynamicRegistries registries, ChunkGenerator generator, TemplateManager manager, int p_230364_4_, int p_230364_5_, Biome p_230364_6_, VillageConfig villageConfig) {
            int i = p_230364_4_ * 16;
            int j = p_230364_5_ * 16;
            if (!OceanWarmTowerPools.registered) {
                OceanWarmTowerPools.init(registries);
            }
            BlockPos blockpos = new BlockPos(i, generator.func_222529_a(i, j, Heightmap.Type.OCEAN_FLOOR_WG) - generator.func_222529_a(i, j, Heightmap.Type.WORLD_SURFACE_WG), j);
            JigsawManager.func_242837_a((DynamicRegistries)registries, (VillageConfig)villageConfig, AbstractVillagePiece::new, (ChunkGenerator)generator, (TemplateManager)manager, (BlockPos)blockpos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)true, (boolean)true);
            this.func_202500_a();
        }
    }
}

