/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.cheaterpaul.fallingleaves.config.LeafSettingsEntry;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LeafSettingGenerator
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;

    public LeafSettingGenerator(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        HashSet set = new HashSet();
        this.registerLeafSettingEntries(entry -> {
            if (!set.add(entry.id)) {
                throw new IllegalStateException("Duplicate leaf setting entry " + entry.id);
            }
            JsonObject object = new JsonObject();
            object.addProperty("spawnrate", (Number)entry.spawnRateFactor);
            object.addProperty("isConifer", Boolean.valueOf(entry.isConiferBlock));
            this.saveLeafSettingEntries(cache, object, path.resolve("data/" + entry.id.func_110624_b() + "/fallingleaves/" + entry.id.func_110623_a() + ".json"));
        });
    }

    public String func_200397_b() {
        return "Falling Leaves leaves settings generator";
    }

    private void saveLeafSettingEntries(DirectoryCache cache, JsonObject entryJson, Path path) {
        try {
            String s = GSON.toJson((JsonElement)entryJson);
            String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
            if (!Objects.equals(cache.func_208323_a(path), s1) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                    bufferedWriter.write(s);
                }
            }
            cache.func_208316_a(path, s1);
        }
        catch (IOException ioExeption) {
            LOGGER.error("Couldn't save skill node {}", (Object)path, (Object)ioExeption);
        }
    }

    protected void registerLeafSettingEntries(Consumer<LeafSettingsEntry> consumer) {
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("minecraft", "spruce_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("minecraft", "jungle_leaves"), 0.0, false));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "blue_spruce_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "cypress_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "fir_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "orange_spruce_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "pine_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "red_spruce_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "yellow_spruce_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "pink_cherry_leaves"), 1.4, false));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "skyris_leaves"), 1.4, false));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("byg", "white_cherry_leaves"), 1.4, false));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("terrestria", "cypress_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("terrestria", "hemlock_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("terrestria", "redwood_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("terrestria", "japenese_maple_shrub_leaves"), 0.0, false));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("terrestria", "jungle_palm_leaves"), 0.0, false));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("terrestria", "yucca_palm_leaves"), 0.0, false));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("terrestria", "sakura_leaves"), 1.4, false));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("traverse", "fir_leaves"), 1.0, true));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("traverse", "brown_autumnal_leaves"), 1.8, false));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("traverse", "orange_autumnal_leaves"), 1.8, false));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("traverse", "red_autumnal_leaves"), 1.8, false));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("traverse", "yellow_autumnal_leaves"), 1.8, false));
        consumer.accept(new LeafSettingsEntry(new ResourceLocation("woods_and_mires", "pine_leaves"), 1.0, true));
    }
}

