/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Bastions;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Cities;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Dungeons;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Fortresses;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Igloos;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Mansions;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Mineshafts;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Outposts;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Pyramids;
import com.telepathicgrunt.repurposedstructures.biomeinjection.RuinedPortals;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Ruins;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Shipwrecks;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Strongholds;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Temples;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Villages;
import com.telepathicgrunt.repurposedstructures.biomeinjection.Wells;
import com.telepathicgrunt.repurposedstructures.biomeinjection.WitchHuts;
import com.telepathicgrunt.repurposedstructures.configs.RSDungeonsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSMainConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSMansionsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSMineshaftsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSOutpostsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSShipwrecksConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSStrongholdsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSTemplesConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSVillagesConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSWellsConfig;
import com.telepathicgrunt.repurposedstructures.configs.RSWitchHutsConfig;
import com.telepathicgrunt.repurposedstructures.misc.EndRemasteredDedicatedLoot;
import com.telepathicgrunt.repurposedstructures.misc.MobMapTrades;
import com.telepathicgrunt.repurposedstructures.misc.MobSpawnerManager;
import com.telepathicgrunt.repurposedstructures.misc.PoolAdditionMerger;
import com.telepathicgrunt.repurposedstructures.mixin.ChunkGeneratorAccessor;
import com.telepathicgrunt.repurposedstructures.modinit.RSConfiguredFeatures;
import com.telepathicgrunt.repurposedstructures.modinit.RSConfiguredStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSFeatures;
import com.telepathicgrunt.repurposedstructures.modinit.RSGlobalLootModifier;
import com.telepathicgrunt.repurposedstructures.modinit.RSPlacements;
import com.telepathicgrunt.repurposedstructures.modinit.RSPredicates;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.BiomeSelection;
import com.telepathicgrunt.repurposedstructures.utils.ConfigHelper;
import com.telepathicgrunt.repurposedstructures.utils.LogSpamFiltering;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;

@Mod(value="repurposed_structures")
public class RepurposedStructures {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "repurposed_structures";
    public static RSMainConfig.RSConfigValues RSMainConfig = null;
    public static RSDungeonsConfig.RSDungeonsConfigValues RSDungeonsConfig = null;
    public static RSMineshaftsConfig.RSMineshaftsConfigValues RSMineshaftsConfig = null;
    public static RSStrongholdsConfig.RSStrongholdsConfigValues RSStrongholdsConfig = null;
    public static RSWellsConfig.RSWellsConfigValues RSWellsConfig = null;
    public static RSOutpostsConfig.RSOutpostsConfigValues RSOutpostsConfig = null;
    public static RSVillagesConfig.RSVillagesConfigValues RSVillagesConfig = null;
    public static RSTemplesConfig.RSTemplesConfigValues RSTemplesConfig = null;
    public static RSShipwrecksConfig.RSShipwrecksConfigValues RSShipwrecksConfig = null;
    public static RSMansionsConfig.RSMansionsConfigValues RSMansionsConfig = null;
    public static RSWitchHutsConfig.RSWitchHutsConfigValues RSWitchHutsConfig = null;
    public static MobSpawnerManager mobSpawnerManager = new MobSpawnerManager();
    public static boolean yungsBetterMineshaftIsNotOn = true;

    public RepurposedStructures() {
        RSMainConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSMainConfig.RSConfigValues::new, "repurposed_structures-common.toml");
        RSDungeonsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSDungeonsConfig.RSDungeonsConfigValues::new, "repurposed_structures-dungeons.toml");
        RSMineshaftsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSMineshaftsConfig.RSMineshaftsConfigValues::new, "repurposed_structures-mineshafts.toml");
        RSStrongholdsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSStrongholdsConfig.RSStrongholdsConfigValues::new, "repurposed_structures-strongholds.toml");
        RSWellsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSWellsConfig.RSWellsConfigValues::new, "repurposed_structures-wells.toml");
        RSShipwrecksConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSShipwrecksConfig.RSShipwrecksConfigValues::new, "repurposed_structures-shipwrecks.toml");
        RSOutpostsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSOutpostsConfig.RSOutpostsConfigValues::new, "repurposed_structures-outposts.toml");
        RSTemplesConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSTemplesConfig.RSTemplesConfigValues::new, "repurposed_structures-temples.toml");
        RSVillagesConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSVillagesConfig.RSVillagesConfigValues::new, "repurposed_structures-villages.toml");
        RSMansionsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSMansionsConfig.RSMansionsConfigValues::new, "repurposed_structures-mansions.toml");
        RSWitchHutsConfig = ConfigHelper.register(ModConfig.Type.COMMON, RSWitchHutsConfig.RSWitchHutsConfigValues::new, "repurposed_structures-witch_huts.toml");
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        forgeBus.addListener(this::biomeModification);
        forgeBus.addListener(this::registerDatapackListener);
        forgeBus.addListener(this::addDimensionalSpacing);
        forgeBus.addListener(MobMapTrades::onVillagerTradesEvent);
        forgeBus.addListener(PoolAdditionMerger::mergeAdditionPools);
        modEventBus.addListener(this::setup);
        RSFeatures.FEATURES.register(modEventBus);
        RSStructures.STRUCTURE_FEATURES.register(modEventBus);
        RSPlacements.DECORATORS.register(modEventBus);
        RSGlobalLootModifier.GLM.register(modEventBus);
        yungsBetterMineshaftIsNotOn = !ModList.get().isLoaded("bettermineshafts");
        EndRemasteredDedicatedLoot.isEndRemasteredOn = ModList.get().isLoaded("endrem");
        Logger rootLogger = LogManager.getRootLogger();
        if (rootLogger instanceof org.apache.logging.log4j.core.Logger) {
            ((org.apache.logging.log4j.core.Logger)rootLogger).addFilter((Filter)new LogSpamFiltering());
        } else {
            LOGGER.error("Registration failed with unexpected class: {}", rootLogger.getClass());
        }
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            RSConfiguredFeatures.registerConfiguredFeatures();
            RSProcessors.registerProcessors();
            RSPredicates.registerPredicates();
            RSStructures.setupStructures();
            RSConfiguredStructures.registerStructureFeatures();
            RSStructureTagMap.setupTags();
            RSGlobalLootModifier.registerLootData();
            BiomeSelection.setupOverworldBiomesSet();
            WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
                Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
                if (structureMap instanceof ImmutableMap) {
                    HashMap tempMap = new HashMap(structureMap);
                    tempMap.putAll(RSStructures.RS_STRUCTURES);
                    ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
                } else {
                    structureMap.putAll(RSStructures.RS_STRUCTURES);
                }
            });
        });
    }

    public void registerDatapackListener(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)mobSpawnerManager);
    }

    public void biomeModification(BiomeLoadingEvent event) {
        Map<String, Pair<List<String>, Consumer<BiomeLoadingEvent>>> allBiomeBlacklists = RepurposedStructures.getBiomeBlacklists();
        RepurposedStructures.addFeaturesAndStructuresToBiomes(event, allBiomeBlacklists);
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        List dimensionBlacklist = Arrays.stream(RepurposedStructures.RSMainConfig.blacklistedDimensions.get().split(",")).map(String::trim).collect(Collectors.toList());
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            ResourceLocation cgRL = Registry.field_239690_aB_.func_177774_c(((ChunkGeneratorAccessor)serverWorld.func_72863_F().field_186029_c).repurposedstructures_getCodec());
            if (cgRL != null && cgRL.func_110624_b().equals("terraforged")) {
                return;
            }
            HashMap tempMap = new HashMap(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            if (dimensionBlacklist.stream().anyMatch(blacklist -> blacklist.equals(serverWorld.func_234923_W_().func_240901_a_().toString()))) {
                tempMap.keySet().removeAll(RSStructures.RS_STRUCTURES.keySet());
            } else if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                tempMap.keySet().removeAll(RSStructures.RS_STRUCTURES.keySet());
            } else {
                Reference2ObjectOpenHashMap spacingToAdd = new Reference2ObjectOpenHashMap();
                spacingToAdd.putAll(RSStructures.RS_STRUCTURES);
                if (serverWorld.func_234923_W_().equals(World.field_234920_i_)) {
                    spacingToAdd.remove(RSStructures.NETHER_STRONGHOLD.get());
                }
                spacingToAdd.forEach(tempMap::putIfAbsent);
            }
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }

    public static void addFeaturesAndStructuresToBiomes(BiomeLoadingEvent event, Map<String, Pair<List<String>, Consumer<BiomeLoadingEvent>>> allBiomeBlacklists) {
        for (Map.Entry<String, Pair<List<String>, Consumer<BiomeLoadingEvent>>> entry : allBiomeBlacklists.entrySet()) {
            if (!RepurposedStructures.isBiomeAllowed(entry.getKey(), event.getName(), allBiomeBlacklists)) continue;
            ((Consumer)entry.getValue().getSecond()).accept(event);
        }
    }

    private static boolean isBiomeAllowed(String structureType, ResourceLocation biomeID, Map<String, Pair<List<String>, Consumer<BiomeLoadingEvent>>> allBiomeBlacklists) {
        return ((List)allBiomeBlacklists.get(structureType).getFirst()).stream().noneMatch(blacklistedBiome -> blacklistedBiome.equals(biomeID.toString()));
    }

    public static Map<String, Pair<List<String>, Consumer<BiomeLoadingEvent>>> getBiomeBlacklists() {
        HashMap<String, Pair<List<String>, Consumer<BiomeLoadingEvent>>> allBiomeBlacklists = new HashMap<String, Pair<List<String>, Consumer<BiomeLoadingEvent>>>();
        allBiomeBlacklists.put("dungeons", Pair.of(Arrays.asList(RepurposedStructures.RSDungeonsConfig.blacklistedDungeonBiomes.get().replace(" ", "").split(",")), Dungeons::addDungeons));
        allBiomeBlacklists.put("fortresses", Pair.of(Arrays.asList(RepurposedStructures.RSMainConfig.blacklistedFortressBiomes.get().replace(" ", "").split(",")), Fortresses::addJungleFortress));
        allBiomeBlacklists.put("igloos", Pair.of(Arrays.asList(RepurposedStructures.RSMainConfig.blacklistedIglooBiomes.get().replace(" ", "").split(",")), Igloos::addIgloos));
        allBiomeBlacklists.put("mineshafts", Pair.of(Arrays.asList(RepurposedStructures.RSMineshaftsConfig.blacklistedMineshaftBiomes.get().replace(" ", "").split(",")), Mineshafts::addMineshafts));
        allBiomeBlacklists.put("outposts", Pair.of(Arrays.asList(RepurposedStructures.RSOutpostsConfig.blacklistedOutpostBiomes.get().replace(" ", "").split(",")), Outposts::addOutposts));
        allBiomeBlacklists.put("shipwrecks", Pair.of(Arrays.asList(RepurposedStructures.RSShipwrecksConfig.blacklistedShipwreckBiomes.get().replace(" ", "").split(",")), Shipwrecks::addShipwrecks));
        allBiomeBlacklists.put("strongholds", Pair.of(Arrays.asList(RepurposedStructures.RSStrongholdsConfig.blacklistedStrongholdBiomes.get().replace(" ", "").split(",")), Strongholds::addStrongholds));
        allBiomeBlacklists.put("temples", Pair.of(Arrays.asList(RepurposedStructures.RSTemplesConfig.blacklistedTempleBiomes.get().replace(" ", "").split(",")), Temples::addTemples));
        allBiomeBlacklists.put("pyramids", Pair.of(Arrays.asList(RepurposedStructures.RSTemplesConfig.blacklistedPyramidBiomes.get().replace(" ", "").split(",")), Pyramids::addPyramids));
        allBiomeBlacklists.put("villages", Pair.of(Arrays.asList(RepurposedStructures.RSVillagesConfig.blacklistedVillageBiomes.get().replace(" ", "").split(",")), Villages::addVillages));
        allBiomeBlacklists.put("wells", Pair.of(Arrays.asList(RepurposedStructures.RSWellsConfig.blacklistedWellBiomes.get().replace(" ", "").split(",")), Wells::addWells));
        allBiomeBlacklists.put("ruinedPortals", Pair.of(Arrays.asList(RepurposedStructures.RSMainConfig.blacklistedRuinedPortalsBiomes.get().replace(" ", "").split(",")), RuinedPortals::addRuinedPortals));
        allBiomeBlacklists.put("ruins", Pair.of(Arrays.asList(RepurposedStructures.RSMainConfig.blacklistedRuinsBiomes.get().replace(" ", "").split(",")), Ruins::addRuins));
        allBiomeBlacklists.put("cities", Pair.of(Arrays.asList(RepurposedStructures.RSMainConfig.blacklistedCitiesBiomes.get().replace(" ", "").split(",")), Cities::addCities));
        allBiomeBlacklists.put("mansions", Pair.of(Arrays.asList(RepurposedStructures.RSMansionsConfig.blacklistedMansionBiomes.get().replace(" ", "").split(",")), Mansions::addMansions));
        allBiomeBlacklists.put("witch_huts", Pair.of(Arrays.asList(RepurposedStructures.RSWitchHutsConfig.blacklistedWitchHutBiomes.get().replace(" ", "").split(",")), WitchHuts::addWitchHuts));
        allBiomeBlacklists.put("underground_bastions", Pair.of(Arrays.asList(RepurposedStructures.RSMainConfig.blacklistedUndergroundBastionBiomes.get().replace(" ", "").split(",")), Bastions::addBastions));
        return allBiomeBlacklists;
    }
}

