/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.biomeinjection;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSConfiguredStructures;
import com.telepathicgrunt.repurposedstructures.utils.BiomeSelection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class Mineshafts {
    public static final Map<StructureFeature<?, ?>, Predicate<BiomeLoadingEvent>> MINESHAFT_TYPE_AND_CONDITIONS = new HashMap();

    public static void addMineshafts(BiomeLoadingEvent event) {
        for (Map.Entry<StructureFeature<?, ?>, Predicate<BiomeLoadingEvent>> mineshaftTypeAndCondition : MINESHAFT_TYPE_AND_CONDITIONS.entrySet()) {
            if (Mineshafts.attemptToAddMineshaft(event, mineshaftTypeAndCondition.getKey(), mineshaftTypeAndCondition.getValue())) break;
        }
    }

    private static boolean attemptToAddMineshaft(BiomeLoadingEvent event, StructureFeature<?, ?> configuredStructureFeature, Predicate<BiomeLoadingEvent> predicate) {
        if (predicate.test(event) && (BiomeSelection.hasNamespace(event, "minecraft") || RepurposedStructures.RSMineshaftsConfig.addMineshaftsToModdedBiomes.get().booleanValue())) {
            if (RepurposedStructures.yungsBetterMineshaftIsNotOn) {
                event.getGeneration().getStructures().removeIf(supplier -> ((StructureFeature)supplier.get()).field_236268_b_ == Structure.field_236367_c_);
            }
            event.getGeneration().getStructures().add(() -> configuredStructureFeature);
            return true;
        }
        return false;
    }

    static {
        MINESHAFT_TYPE_AND_CONDITIONS.put(RSConfiguredStructures.BIRCH_MINESHAFT, event -> RepurposedStructures.RSMineshaftsConfig.birchMineshaftSpawnrate.get() != 0.0 && BiomeSelection.hasName(event, "birch"));
        MINESHAFT_TYPE_AND_CONDITIONS.put(RSConfiguredStructures.JUNGLE_MINESHAFT, event -> RepurposedStructures.RSMineshaftsConfig.jungleMineshaftSpawnrate.get() != 0.0 && BiomeSelection.haveCategories(event, Biome.Category.JUNGLE));
        MINESHAFT_TYPE_AND_CONDITIONS.put(RSConfiguredStructures.DESERT_MINESHAFT, event -> RepurposedStructures.RSMineshaftsConfig.desertMineshaftSpawnrate.get() != 0.0 && BiomeSelection.haveCategories(event, Biome.Category.DESERT));
        MINESHAFT_TYPE_AND_CONDITIONS.put(RSConfiguredStructures.STONE_MINESHAFT, event -> RepurposedStructures.RSMineshaftsConfig.stoneMineshaftSpawnrate.get() != 0.0 && BiomeSelection.haveCategories(event, Biome.Category.EXTREME_HILLS));
        MINESHAFT_TYPE_AND_CONDITIONS.put(RSConfiguredStructures.SAVANNA_MINESHAFT, event -> RepurposedStructures.RSMineshaftsConfig.savannaMineshaftSpawnrate.get() != 0.0 && BiomeSelection.haveCategories(event, Biome.Category.SAVANNA));
        MINESHAFT_TYPE_AND_CONDITIONS.put(RSConfiguredStructures.ICY_MINESHAFT, event -> RepurposedStructures.RSMineshaftsConfig.icyMineshaftSpawnrate.get() != 0.0 && (BiomeSelection.haveCategories(event, Biome.Category.ICY) || BiomeSelection.hasName(event, "snowy")));
        MINESHAFT_TYPE_AND_CONDITIONS.put(RSConfiguredStructures.OCEAN_MINESHAFT, event -> RepurposedStructures.RSMineshaftsConfig.oceanMineshaftSpawnrate.get() != 0.0 && BiomeSelection.haveCategories(event, Biome.Category.OCEAN));
        MINESHAFT_TYPE_AND_CONDITIONS.put(RSConfiguredStructures.TAIGA_MINESHAFT, event -> RepurposedStructures.RSMineshaftsConfig.taigaMineshaftSpawnrate.get() != 0.0 && BiomeSelection.haveCategories(event, Biome.Category.TAIGA));
        MINESHAFT_TYPE_AND_CONDITIONS.put(RSConfiguredStructures.DARK_FOREST_MINESHAFT, event -> RepurposedStructures.RSMineshaftsConfig.darkForestMineshaftSpawnrate.get() != 0.0 && BiomeSelection.haveCategories(event, Biome.Category.FOREST) && BiomeSelection.hasName(event, "dark", "spooky", "dead", "haunted"));
        MINESHAFT_TYPE_AND_CONDITIONS.put(RSConfiguredStructures.SWAMP_MINESHAFT, event -> RepurposedStructures.RSMineshaftsConfig.swampMineshaftSpawnrate.get() != 0.0 && BiomeSelection.haveCategories(event, Biome.Category.SWAMP));
        MINESHAFT_TYPE_AND_CONDITIONS.put(RSConfiguredStructures.END_MINESHAFT, event -> RepurposedStructures.RSMineshaftsConfig.endMineshaftSpawnrate.get() != 0.0 && BiomeSelection.haveCategories(event, Biome.Category.THEEND) && !BiomeSelection.isBiome(event, Biomes.field_76779_k) && (RepurposedStructures.RSMineshaftsConfig.barrensIslandsEndMineshafts.get() != false || !BiomeSelection.isBiome(event, Biomes.field_201939_S, Biomes.field_201936_P)));
        MINESHAFT_TYPE_AND_CONDITIONS.put(RSConfiguredStructures.NETHER_MINESHAFT, event -> RepurposedStructures.RSMineshaftsConfig.netherMineshaftSpawnrate.get() != 0.0 && !BiomeSelection.hasName(event, "crimson", "_red", "warped", "blue") && BiomeSelection.haveCategories(event, Biome.Category.NETHER));
        MINESHAFT_TYPE_AND_CONDITIONS.put(RSConfiguredStructures.CRIMSON_MINESHAFT, event -> RepurposedStructures.RSMineshaftsConfig.crimsonMineshaftSpawnrate.get() != 0.0 && BiomeSelection.hasName(event, "crimson", "_red") && BiomeSelection.haveCategories(event, Biome.Category.NETHER));
        MINESHAFT_TYPE_AND_CONDITIONS.put(RSConfiguredStructures.WARPED_MINESHAFT, event -> RepurposedStructures.RSMineshaftsConfig.warpedMineshaftSpawnrate.get() != 0.0 && BiomeSelection.hasName(event, "warped", "blue") && BiomeSelection.haveCategories(event, Biome.Category.NETHER));
    }
}

